/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.world.dimension.generator;

import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.init.AquaticBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenReefs
implements IWorldGenerator {
    public WorldGenerator genCoralReef = new WorldGenOreReef();

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && (!(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76220_a() || state.func_185904_a().func_76224_d() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos1) || state.func_177230_c().isFoliage((IBlockAccess)world, blockpos1))) {
            blockpos = blockpos1;
        }
        return blockpos.func_177977_b();
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == AquaticConfig.dimensionID) {
            this.runGenerator(world, rand, chunkX, chunkZ, 0, world.func_181545_F() - 4);
        }
    }

    private void runGenerator(World world, Random rand, int chunk_X, int chunk_Z, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        if (rand.nextInt(10) == 0) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int z = chunk_Z * 16 + rand.nextInt(16);
            int y = MathHelper.func_76125_a((int)WorldGenReefs.getTopSolidOrLiquidBlock(world, new BlockPos(x, 64, z)).func_177956_o(), (int)minHeight, (int)maxHeight);
            BlockPos position = new BlockPos(x + 8, y, z + 8);
            this.genCoralReef.func_180709_b(world, rand, position);
        }
    }

    public class WorldGenOreReef
    extends WorldGenerator {
        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            int r = MathHelper.func_76125_a((int)rand.nextInt(7), (int)4, (int)7);
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    Block block;
                    BlockPos pos = WorldGenReefs.getTopSolidOrLiquidBlock(worldIn, new BlockPos(position.func_177958_n() + x, position.func_177956_o(), position.func_177952_p() + z));
                    if (x * x + z * z > r * r || rand.nextInt(r) < r / 2 || pos.func_177956_o() > worldIn.func_181545_F() - 5 || (block = worldIn.func_180495_p(pos).func_177230_c()) != AquaticBlocks.AQUATIC_STONE && block != AquaticBlocks.AQUATIC_STONE_CRACKED && block != Blocks.field_150354_m && block != AquaticBlocks.REEF_STONE.func_176223_P()) continue;
                    if (worldIn.func_175656_a(pos, AquaticBlocks.REEF_STONE.func_176223_P())) {
                        // empty if block
                    }
                    IBlockState variant = AquaticBlocks.CORAL_REEF_BLUE.func_176223_P();
                    IBlockState variant1 = AquaticBlocks.CORAL_REEF_GREEN.func_176223_P();
                    IBlockState variant2 = AquaticBlocks.CORAL_REEF_RED.func_176223_P();
                    IBlockState variant3 = AquaticBlocks.CORAL_REEF_YELLOW.func_176223_P();
                    IBlockState variant4 = AquaticBlocks.CORAL_REEF_PINK.func_176223_P();
                    IBlockState variant5 = AquaticBlocks.HYDRILLA.func_176223_P();
                    IBlockState variant6 = AquaticBlocks.OXYGEN_STONE.func_176223_P();
                    block11: for (int i = 1; i <= rand.nextInt(4); ++i) {
                        Random random = new Random();
                        switch (random.nextInt(11)) {
                            case 0: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant1);
                                continue block11;
                            }
                            case 1: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant);
                                continue block11;
                            }
                            case 2: {
                                worldIn.func_175656_a(pos.func_177981_b(i), variant2);
                                continue block11;
                            }
                            case 3: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant3);
                                continue block11;
                            }
                            case 4: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant4);
                                continue block11;
                            }
                            case 5: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant5);
                                continue block11;
                            }
                            case 6: {
                                worldIn.func_175656_a(pos.func_177984_a(), variant6);
                            }
                        }
                    }
                }
            }
            return true;
        }
    }
}

