/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.world.dimension.generator;

import com.github.rapture.aquatic.init.AquaticBlocks;
import com.github.rapture.aquatic.world.dimension.generator.AquaticGenerator;
import com.github.rapture.aquatic.world.dimension.generator.WorldGenEntities;
import com.github.rapture.aquatic.world.dimension.generator.WorldGenPlants;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorAquatic
implements IChunkGenerator {
    protected static final IBlockState WATER = AquaticBlocks.AQUA_WATER_BLOCK.func_176223_P();
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState AQUA_STONE = AquaticBlocks.AQUATIC_STONE.func_176223_P();
    private static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private static final IBlockState SAND = Blocks.field_150354_m.func_176223_P();
    private static final IBlockState STONE_CRACKED = AquaticBlocks.AQUATIC_STONE_CRACKED.func_176223_P();
    private final WorldGenerator ironGen = new WorldGenMinable(AquaticBlocks.IRON_ORE_DEPOSIT.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator goldGen = new WorldGenMinable(AquaticBlocks.GOLD_ORE_DEPOSIT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator diamonGen = new WorldGenMinable(AquaticBlocks.DIAMOND_ORE_DEPOSIT.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator coalGen = new WorldGenMinable(AquaticBlocks.COAL_ORE_DEPOSIT.func_176223_P(), 18, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator emeraldGen = new WorldGenMinable(AquaticBlocks.EMERALD_ORE_DEPOSIT.func_176223_P(), 2, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator lapizGen = new WorldGenMinable(AquaticBlocks.LAPIZ_ORE_DEPOSIT.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator redstoneGen = new WorldGenMinable(AquaticBlocks.REDSTONE_ORE_DEPOSIT.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator quartzGen = new WorldGenMinable(AquaticBlocks.QUARTZ_ORE_DEPOSIT.func_176223_P(), 13, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    private final WorldGenerator aquaCrackedStone = new WorldGenMinable(AquaticBlocks.AQUATIC_STONE_CRACKED.func_176223_P(), 60, (Predicate)BlockMatcher.func_177642_a((Block)AquaticBlocks.AQUATIC_STONE));
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;
    private WorldGenPlants coralGenerator0 = new WorldGenPlants(AquaticBlocks.CORAL_REEF_GREEN);
    private WorldGenPlants coralGenerator1 = new WorldGenPlants(AquaticBlocks.CORAL_REEF_PINK);
    private WorldGenPlants coralGenerator2 = new WorldGenPlants(AquaticBlocks.CORAL_REEF_RED);
    private WorldGenPlants coralGenerator3 = new WorldGenPlants(AquaticBlocks.CORAL_REEF_YELLOW);
    private WorldGenPlants coralGenerator4 = new WorldGenPlants(AquaticBlocks.CORAL_REEF_BLUE);
    private WorldGenPlants hydrillaGenerator = new WorldGenPlants(AquaticBlocks.HYDRILLA);
    private WorldGenPlants oxygenGenerator = new WorldGenPlants(AquaticBlocks.OXYGEN_STONE);
    private NoiseGeneratorOctaves scaleNoise;
    private NoiseGeneratorOctaves depthNoise;
    private World world;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves stoneExculsivityNoiseGen;
    private AquaticGenerator gensPerlin;
    private Random rand;

    public ChunkGeneratorAquatic(World world) {
        this.world = world;
        this.rand = new Random();
        this.rand.setSeed(this.rand.nextLong());
        this.gensPerlin = new AquaticGenerator(this.rand, 16);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.stoneExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.stoneExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.stoneExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.world.func_181544_b(87);
    }

    private void prepareHeights(int p_185936_1_, int p_185936_2_, ChunkPrimer primer) {
        int j = this.world.func_181545_F() / 2 + 1;
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * 4, 0, p_185936_2_ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d1 = this.buffer[(j1 * 5 + k1) * 17 + l1];
                    double d2 = this.buffer[(j1 * 5 + k1 + 1) * 17 + l1];
                    double d3 = this.buffer[((j1 + 1) * 5 + k1) * 17 + l1];
                    double d4 = this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1];
                    double d5 = (this.buffer[(j1 * 5 + k1) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (this.buffer[(j1 * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((j1 + 1) * 5 + k1) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = WATER;
                                }
                                if (d15 > 0.0) {
                                    iblockstate = AQUA_STONE;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void buildSurfaces(int p_185937_1_, int p_185937_2_, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)p_185937_1_, (int)p_185937_2_, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, p_185937_1_ * 16, 109, p_185937_2_ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.depthBuffer = this.stoneExculsivityNoiseGen.func_76304_a(this.depthBuffer, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                boolean flag = this.slowsandNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = AQUA_STONE;
                IBlockState iblockstate1 = AQUA_STONE;
                for (int j1 = 127; j1 >= 0; --j1) {
                    if (j1 < 127 - this.rand.nextInt(5) && j1 > this.rand.nextInt(5)) {
                        IBlockState iblockstate2 = primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != AquaticBlocks.AQUATIC_STONE) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = AIR;
                                    iblockstate1 = AQUA_STONE;
                                } else if (j1 >= i - 4 && j1 <= i + 1) {
                                    iblockstate = AQUA_STONE;
                                    iblockstate1 = AQUA_STONE;
                                    if (flag1) {
                                        iblockstate = SAND;
                                        iblockstate1 = AQUA_STONE;
                                    }
                                    if (flag) {
                                        iblockstate = STONE_CRACKED;
                                        iblockstate1 = STONE_CRACKED;
                                    }
                                }
                                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                                    iblockstate = WATER;
                                }
                                i1 = l;
                                if (j1 >= i - 1) {
                                    primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(k, j1, j, BEDROCK);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkprimer);
        this.buildSurfaces(x, z, chunkprimer);
        this.generateBedrockLayer(chunkprimer, this.rand, 0);
        this.generateWater(chunkprimer, this.rand, 1);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] abiome = this.world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)abiome[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private void generateBedrockLayer(ChunkPrimer p, Random r, int y) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                p.func_177855_a(x, y, z, BEDROCK);
                p.func_177855_a(x, 128, z, Blocks.field_150357_h.func_176223_P());
            }
        }
    }

    private void generateWater(ChunkPrimer p, Random r, int yn) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 86; ++y) {
                    if (p.func_177856_a(x, y + yn, z) != Blocks.field_150350_a.func_176223_P()) continue;
                    p.func_177855_a(x, y + yn, z, WATER);
                }
            }
        }
    }

    private double[] getHeights(double[] p_185938_1_, int p_185938_2_, int p_185938_3_, int p_185938_4_, int p_185938_5_, int p_185938_6_, int p_185938_7_) {
        if (p_185938_1_ == null) {
            p_185938_1_ = new double[p_185938_5_ * p_185938_6_ * p_185938_7_];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185938_1_, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 1.0, 0.0, 1.0);
        this.dr = this.depthNoise.func_76304_a(this.dr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, 1, p_185938_7_, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 8.555150000000001, 34.2206, 8.555150000000001);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185938_2_, p_185938_3_, p_185938_4_, p_185938_5_, p_185938_6_, p_185938_7_, 684.412, 2053.236, 684.412);
        int i = 0;
        double[] adouble = new double[p_185938_6_];
        for (int j = 0; j < p_185938_6_; ++j) {
            adouble[j] = Math.cos((double)j * Math.PI * 6.0 / (double)p_185938_6_) * 2.0;
            double d2 = j;
            if (j > p_185938_6_ / 2) {
                d2 = p_185938_6_ - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble[n] = adouble[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < p_185938_5_; ++l) {
            for (int i1 = 0; i1 < p_185938_7_; ++i1) {
                for (int k = 0; k < p_185938_6_; ++k) {
                    double d4 = adouble[k];
                    double d5 = this.ar[i] / 512.0;
                    double d6 = this.br[i] / 512.0;
                    double d7 = (this.pnr[i] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > p_185938_6_ - 4) {
                        double d9 = (float)(k - (p_185938_6_ - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    p_185938_1_[i] = d8;
                    ++i;
                }
            }
        }
        return p_185938_1_;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, blockpos));
        if (this.rand.nextInt(3) == 0) {
            this.coralGenerator0.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.coralGenerator1.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.coralGenerator2.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.coralGenerator3.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.coralGenerator4.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.hydrillaGenerator.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(3) == 0) {
            this.oxygenGenerator.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(128), this.rand.nextInt(16) + 8));
        }
        biome.func_180624_a(this.world, this.rand, blockpos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldGenEntities.spawnMobsInWorldGen(this.world, biome, i + 8, j + 8, 16, 16, this.rand);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, blockpos));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (biome != null) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

