/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.util;

import com.github.rapture.aquatic.Aquatic;
import com.github.rapture.aquatic.config.AquaticConfig;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;

public class UpdateChecker {
    public static boolean hasUpdate() {
        if (AquaticConfig.enableUpdateChecker) {
            ForgeVersion.CheckResult result = UpdateChecker.getResult();
            ForgeVersion.Status status = result.status;
            if (status != ForgeVersion.Status.PENDING && status != ForgeVersion.Status.FAILED) {
                return status == ForgeVersion.Status.OUTDATED || AquaticConfig.announceBetaUpdates && status == ForgeVersion.Status.BETA_OUTDATED;
            }
            Aquatic.getLogger().warn("Error getting update status for {}, found status {}!", (Object)"aquatic", (Object)status.toString());
        }
        return false;
    }

    public static ForgeVersion.CheckResult getResult() {
        return ForgeVersion.getResult((ModContainer)FMLCommonHandler.instance().findContainerFor((Object)"aquatic"));
    }

    public static void notifyServer() {
        if (UpdateChecker.hasUpdate()) {
            ForgeVersion.CheckResult result = UpdateChecker.getResult();
            Aquatic.getLogger().warn("There's an update available for {}, download version {} here: {}", (Object)"Aquatic", (Object)result.target, (Object)result.url);
        }
    }
}

