/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.util;

import com.github.rapture.aquatic.util.CustomItemStackHandler;
import com.github.rapture.aquatic.util.TileEntityBase;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInventory
extends TileEntityBase {
    public final CustomItemStackHandler inventory;

    public TileEntityInventory(int slots) {
        this.inventory = new CustomItemStackHandler(slots){

            @Override
            public boolean canInsert(ItemStack stack, int slot) {
                return TileEntityInventory.this.isItemValidForSlot(slot, stack);
            }

            @Override
            public boolean canExtract(ItemStack stack, int slot) {
                return TileEntityInventory.this.canExtractItem(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return TileEntityInventory.this.getMaxStackSizePerSlot(slot);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityInventory.this.func_70296_d();
            }
        };
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
    }

    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.inventory;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public boolean canExtractItem(int slot, ItemStack stack) {
        return true;
    }

    public int getMaxStackSizePerSlot(int slot) {
        return 64;
    }

    public void decrease(int slot) {
        if (!this.inventory.getStackInSlot(slot).func_190926_b()) {
            if (this.inventory.getStackInSlot(slot).func_190916_E() > 1) {
                this.inventory.getStackInSlot(slot).func_190918_g(1);
            } else {
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        IItemHandler handler;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (handler = this.getItemHandler(facing)) != null) {
            return (T)handler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

