/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidUtils {
    public static void translateAgainstPlayer(BlockPos pos, boolean offset) {
        float x = (float)((double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b);
        float y = (float)((double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c);
        float z = (float)((double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d);
        if (offset) {
            GlStateManager.func_179137_b((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        } else {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        }
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double width, double height, double length) {
        double x1 = (1.0 - width) / 2.0;
        double y1 = (1.0 - height) / 2.0;
        double z1 = (1.0 - length) / 2.0;
        FluidUtils.renderFluid(fluid, pos, x, y, z, x1, y1, z1, 1.0 - x1, 1.0 - y1, 1.0 - z1);
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        FluidUtils.renderFluid(fluid, pos, x, y, z, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int brightness = mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        FluidUtils.setupRenderState(x, y, z);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness);
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness);
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness);
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness);
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness);
        FluidUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness);
        tessellator.func_78381_a();
        FluidUtils.cleanupRenderState();
    }

    @Deprecated
    public static void setupRenderState(double x, double y, double z) {
        FluidUtils.setupRenderState();
    }

    public static void setupRenderState() {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
    }

    public static void addTexturedQuad(BufferBuilder buffer, TextureAtlasSprite sprite, double x, double y, double z, double width, double height, double length, EnumFacing face, int color, int brightness) {
        if (sprite == null) {
            return;
        }
        int firstLightValue = brightness >> 16 & 0xFFFF;
        int secondLightValue = brightness & 0xFFFF;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        FluidUtils.addTextureQuad(buffer, sprite, x, y, z, width, height, length, face, red, green, blue, alpha, firstLightValue, secondLightValue);
    }

    public static void addTextureQuad(BufferBuilder buffer, TextureAtlasSprite sprite, double x, double y, double z, double width, double height, double length, EnumFacing face, int red, int green, int blue, int alpha, int light1, int light2) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double vz1;
        double vy1;
        double u1;
        double size = 16.0;
        double x2 = x + width;
        double y2 = y + height;
        double z2 = z + length;
        double u = x % 1.0;
        for (u1 = u + width; u1 > 1.0; u1 -= 1.0) {
        }
        double vy = y % 1.0;
        for (vy1 = vy + height; vy1 > 1.0; vy1 -= 1.0) {
        }
        double vz = z % 1.0;
        for (vz1 = vz + length; vz1 > 1.0; vz1 -= 1.0) {
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(u * 16.0);
                maxU = sprite.func_94214_a(u1 * 16.0);
                minV = sprite.func_94207_b(vz * 16.0);
                maxV = sprite.func_94207_b(vz1 * 16.0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(u1 * 16.0);
                maxU = sprite.func_94214_a(u * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(vz1 * 16.0);
                maxU = sprite.func_94214_a(vz * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }

    public static void cleanupRenderState() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }
}

