/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.util;

import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class CustomItemStackHandler
extends ItemStackHandler {
    private boolean tempIgnoreConditions;

    public CustomItemStackHandler(int slots) {
        super(slots);
    }

    public static ItemStack setStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        if (size <= 0) {
            if (CustomItemStackHandler.isValid(stack) && containerOnEmpty) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return ItemStack.field_190927_a;
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack addStackSize(ItemStack stack, int size) {
        return CustomItemStackHandler.addStackSize(stack, size, false);
    }

    public static ItemStack addStackSize(ItemStack stack, int size, boolean containerOnEmpty) {
        return CustomItemStackHandler.setStackSize(stack, CustomItemStackHandler.getStackSize(stack) + size, containerOnEmpty);
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && !stack.func_190926_b();
    }

    public static int getStackSize(ItemStack stack) {
        if (!CustomItemStackHandler.isValid(stack)) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public void decrStackSize(int slot, int amount) {
        this.setStackInSlot(slot, CustomItemStackHandler.addStackSize(this.getStackInSlot(slot), -amount));
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.tempIgnoreConditions && !this.canInsert(stack, slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        this.tempIgnoreConditions = true;
        ItemStack result = this.insertItem(slot, stack, simulate);
        this.tempIgnoreConditions = false;
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.tempIgnoreConditions && !this.canExtract(this.getStackInSlot(slot), slot)) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        this.tempIgnoreConditions = true;
        ItemStack result = this.extractItem(slot, amount, simulate);
        this.tempIgnoreConditions = false;
        return result;
    }

    public boolean canInsert(ItemStack stack, int slot) {
        return true;
    }

    public boolean canExtract(ItemStack stack, int slot) {
        return true;
    }
}

