/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.util;

import com.github.rapture.aquatic.Aquatic;
import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.item.ItemBlockBase;
import com.github.rapture.aquatic.util.FluidUtil;
import com.github.rapture.aquatic.util.IHasItemBlock;
import com.github.rapture.aquatic.util.RegistryCreate;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="aquatic")
public class AutoRegistry {
    private static final IForgeRegistry<Item> ITEM_REGISTRY = GameRegistry.findRegistry(Item.class);
    private static final Map<Class, String> REGISTRY_CLASSES = new ConcurrentHashMap<Class, String>();

    @SubscribeEvent
    public static <T extends IForgeRegistryEntry<T>> void onRegisterStuff(RegistryEvent.Register event) {
        ModContainer currentModContainer = Loader.instance().activeModContainer();
        IForgeRegistry registry = event.getRegistry();
        Aquatic.getLogger().debug("Registering type {}", (Object)registry.getRegistrySuperType().getSimpleName());
        int count = 0;
        block0: for (Class clazz : REGISTRY_CLASSES.keySet()) {
            RegistryCreate classAnnotation = clazz.getAnnotation(RegistryCreate.class);
            for (Class type : classAnnotation.value()) {
                if (!registry.getRegistrySuperType().isAssignableFrom(type)) continue;
                String modid = REGISTRY_CLASSES.get(clazz);
                Loader.instance().setActiveModContainer(FMLCommonHandler.instance().findContainerFor((Object)modid));
                count += AutoRegistry.createRegistryEntries(registry, clazz, modid);
                continue block0;
            }
        }
        Loader.instance().setActiveModContainer(currentModContainer);
        if (AquaticConfig.debugMode) {
            Aquatic.getLogger().info("Active mod container restored.");
            Aquatic.getLogger().info("successfully registered {} objects for event {}", (Object)count, (Object)registry.getRegistrySuperType().getSimpleName().toUpperCase(Locale.ROOT));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static <T extends IForgeRegistryEntry<T>> void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        FluidUtil.addBuckets();
    }

    public static void findRegistryEntries(FMLPreInitializationEvent event) {
        Set dataTable = event.getAsmData().getAll(RegistryCreate.class.getCanonicalName());
        ModContainer originalModContainer = Loader.instance().activeModContainer();
        StringBuilder list = new StringBuilder();
        dataTable.forEach(asmData -> {
            try {
                String modid = (String)asmData.getAnnotationInfo().get("modid");
                Loader.instance().setActiveModContainer(FMLCommonHandler.instance().findContainerFor((Object)modid));
                String className = asmData.getClassName();
                Class<?> clazz = Class.forName(className);
                REGISTRY_CLASSES.put(clazz, modid);
                list.append("\n\t").append(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                FMLCommonHandler.instance().exitJava(1, true);
            }
        });
        Loader.instance().setActiveModContainer(originalModContainer);
        if (AquaticConfig.debugMode) {
            Aquatic.getLogger().debug("Mod container restored. The following classes were determined for registry entry examination: {}", (Object)list.toString());
        }
    }

    private static <T extends IForgeRegistryEntry<T>> int createRegistryEntries(IForgeRegistry<T> registry, Class clazz, String modid) {
        int count = 0;
        Class type = registry.getRegistrySuperType();
        for (Field f : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(f.getType())) continue;
            try {
                IForgeRegistryEntry entry = (IForgeRegistryEntry)f.get(null);
                if (entry.getRegistryName() == null) {
                    Aquatic.getLogger().warn("No registry name set for {}:{}, substituting field name", (Object)clazz.getName(), (Object)f.getName());
                    entry.setRegistryName(new ResourceLocation(modid, f.getName().toLowerCase()));
                }
                registry.register(entry);
                ++count;
                if (Item.class.isAssignableFrom(type)) {
                    Aquatic.proxy.registerRender((Item)entry);
                } else if (Block.class.isAssignableFrom(type)) {
                    Block block = (Block)entry;
                    Class<ItemBlockBase> itemBlockClass = ItemBlockBase.class;
                    Object[] cArgs = new Object[]{};
                    if (block instanceof IHasItemBlock) {
                        IHasItemBlock block1 = (IHasItemBlock)block;
                        itemBlockClass = block1.getItemBlockClass();
                        cArgs = block1.getAdditionalItemBlockConstructorArguments();
                    }
                    if (itemBlockClass != null) {
                        Class[] ctorArgClasses = new Class[cArgs.length + 1];
                        ctorArgClasses[0] = Block.class;
                        for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                            ctorArgClasses[idx] = cArgs[idx - 1].getClass();
                        }
                        Constructor itemCtor = itemBlockClass.getConstructor(ctorArgClasses);
                        Item itemBlock = (Item)itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])cArgs));
                        if (itemBlock.getRegistryName() == null) {
                            itemBlock.setRegistryName(block.getRegistryName());
                        }
                        ITEM_REGISTRY.register((IForgeRegistryEntry)itemBlock);
                        ++count;
                        Aquatic.proxy.registerRender(block);
                    }
                }
            }
            catch (Exception e) {
                Aquatic.getLogger().error("Exception thrown during registration step!", (Throwable)e);
            }
            if (Modifier.isFinal(f.getModifiers())) continue;
            Aquatic.getLogger().warn("{}:{} has no final modifier! Please change this!", (Object)clazz.getName(), (Object)f.getName());
        }
        return count;
    }
}

