/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.proxy.CommonProxy;
import com.github.rapture.aquatic.util.TileEntityInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSolutionTank
extends TileEntityInventory
implements ITickable {
    public FluidTank tank = new FluidTank(8000){

        public void onContentsChanged() {
            if (this.tile != null) {
                IBlockState state = this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v());
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), state, state, 8);
                this.tile.func_70296_d();
            }
        }
    };

    public TileSolutionTank() {
        super(3);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("FluidData")) {
            this.tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("FluidData")));
        }
        if (this.tank != null) {
            this.tank.setTileEntity((TileEntity)this);
            if (this.tank.getFluid() != null) {
                this.tank.readFromNBT(nbt);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.tank != null && this.tank.getFluid() != null) {
            NBTTagCompound tankTag = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(tankTag);
            nbt.func_74782_a("FluidData", (NBTBase)tankTag);
            this.tank.writeToNBT(nbt);
        }
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (!this.inventory.getStackInSlot(1).func_190926_b() && this.inventory.getStackInSlot(1).func_77973_b() == Items.field_151133_ar && this.tank.getFluidAmount() >= 1000 && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.inventory.getStackInSlot(2).func_190926_b()) {
            this.decrease(1);
            this.inventory.setStackInSlot(2, new ItemStack(Items.field_151131_as));
            this.tank.drain(1000, true);
        }
        if (this.tank.getFluidAmount() > 0 && this.tank.getFluid().isFluidEqual(new FluidStack(CommonProxy.AQUA_WATER, 1000))) {
            if (this.tank.getFluid().tag != null) {
                double randomValue = (double)Math.round(Math.sqrt(6.0 + 8.0 * this.field_145850_b.field_73012_v.nextDouble()) * 100.0) / 100.0;
                this.tank.getFluid().tag.func_74780_a("ph", randomValue);
            } else {
                this.tank.getFluid().tag = new NBTTagCompound();
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }
}

