/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.api.oxygen.IOxygenProvider;
import com.github.rapture.aquatic.api.oxygen.OxygenHandler;
import com.github.rapture.aquatic.api.oxygen.capability.CapabilityOxygen;
import com.github.rapture.aquatic.init.AquaticBlocks;
import com.github.rapture.aquatic.tileentity.TileAquaNetController;
import com.github.rapture.aquatic.util.TileEntityInventory;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileOxygenFiller
extends TileEntityInventory
implements ITickable {
    public OxygenHandler oxygen = new OxygenHandler(100000);
    private boolean hasAquaController = false;
    @Nullable
    private BlockPos controllerPos = null;

    public TileOxygenFiller() {
        super(2);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.oxygen.readFromNBT(nbt);
        this.hasAquaController = nbt.func_74767_n("hasAquaController");
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z")) {
            this.controllerPos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.oxygen.writeToNBT(nbt);
        nbt.func_74757_a("hasAquaController", this.hasAquaController);
        if (this.controllerPos != null) {
            nbt.func_74768_a("x", this.controllerPos.func_177958_n());
            nbt.func_74768_a("y", this.controllerPos.func_177956_o());
            nbt.func_74768_a("z", this.controllerPos.func_177952_p());
        }
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (!this.hasAquaController) {
            for (BlockPos bp : BlockPos.func_191532_a((int)(this.field_174879_c.func_177958_n() - 15), (int)(this.field_174879_c.func_177956_o() - 15), (int)(this.field_174879_c.func_177952_p() - 15), (int)(this.field_174879_c.func_177958_n() + 15), (int)(this.field_174879_c.func_177956_o() + 15), (int)(this.field_174879_c.func_177952_p() + 15))) {
                IBlockState state = this.field_145850_b.func_180495_p(bp);
                if (this.field_145850_b.func_175623_d(bp) || state.func_177230_c() != AquaticBlocks.AQUANET_CONTROLLER) continue;
                this.controllerPos = bp;
                this.hasAquaController = true;
            }
        } else if (this.controllerPos != null && this.field_145850_b.func_175625_s(this.controllerPos) != null) {
            if (!(this.field_145850_b.func_175625_s(this.controllerPos) instanceof TileAquaNetController)) {
                this.hasAquaController = false;
                return;
            }
            TileAquaNetController controller = (TileAquaNetController)this.field_145850_b.func_175625_s(this.controllerPos);
            if (controller.oxygen.canSendOxygen(20) && this.oxygen.canReceiveOxygen(20)) {
                controller.oxygen.drainOxygen(20);
                this.oxygen.fillOxygen(20);
            }
        } else {
            this.hasAquaController = false;
        }
        if (!this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(0).hasCapability(CapabilityOxygen.OXYGEN_CAPABILITY, EnumFacing.UP)) {
            IOxygenProvider oxygenProvider = (IOxygenProvider)this.inventory.getStackInSlot(0).getCapability(CapabilityOxygen.OXYGEN_CAPABILITY, EnumFacing.UP);
            if (oxygenProvider.getOxygenStored() < oxygenProvider.getMaxOxygenStorage()) {
                if (oxygenProvider.canReceiveOxygen(20) && this.oxygen.canSendOxygen(20)) {
                    oxygenProvider.fillOxygen(20);
                    this.oxygen.drainOxygen(20);
                }
            } else {
                this.inventory.setStackInSlot(1, this.inventory.getStackInSlot(0));
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return (T)this.oxygen;
        }
        return super.getCapability(capability, facing);
    }
}

