/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.client.render.hud.HudRender;
import com.github.rapture.aquatic.client.render.hud.IHudSupport;
import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.util.CustomEnergyStorage;
import com.github.rapture.aquatic.util.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.oredict.OreDictionary;

public class TileDepthGenerator
extends TileEntityBase
implements IHudSupport,
ITickable {
    private static List<Block> ores = new ArrayList<Block>();
    private CustomEnergyStorage storage = new CustomEnergyStorage(1000000);
    private int timer = 0;

    public static void init() {
        for (String string : OreDictionary.getOreNames()) {
            if (!string.toLowerCase().startsWith("ore")) continue;
            ores.add(Block.func_149634_a((Item)((ItemStack)OreDictionary.getOres((String)string).get(0)).func_77973_b()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
        this.timer = nbt.func_74762_e("timer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("timer", this.timer);
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150357_h) {
            for (BlockPos po : BlockPos.func_191532_a((int)(this.field_174879_c.func_177958_n() - 5), (int)this.field_174879_c.func_177956_o(), (int)(this.field_174879_c.func_177952_p() - 5), (int)(this.field_174879_c.func_177958_n() + 5), (int)this.field_174879_c.func_177956_o(), (int)(this.field_174879_c.func_177952_p() + 5))) {
                if (!this.field_145850_b.func_175623_d(po) || this.storage.getEnergyStored() < AquaticConfig.depthUsage || ores.size() <= 0) continue;
                ++this.timer;
                if (this.timer < 300) continue;
                this.storage.extractEnergy(AquaticConfig.depthUsage, false);
                this.field_145850_b.func_175656_a(po, ores.get(this.field_145850_b.field_73012_v.nextInt(ores.size())).func_176223_P());
                this.timer = 0;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public EnumFacing getBlockOrientation() {
        return HudRender.getOrientationHoriz(this.func_145832_p());
    }

    @Override
    public String getDisplay() {
        return this.storage.getEnergyStored() + " FE";
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }
}

