/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.util.TileEntityBase;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCreativeGenerator
extends TileEntityBase
implements IEnergyStorage,
ITickable {
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return maxExtract;
    }

    public int getEnergyStored() {
        return this.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return 1000000;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyStorage energyStorage;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || !(energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).canReceive()) continue;
            energyStorage.receiveEnergy(AquaticConfig.creativeBatteryMaxTransfer, false);
        }
    }
}

