/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.api.oxygen.OxygenHandler;
import com.github.rapture.aquatic.api.oxygen.capability.CapabilityOxygen;
import com.github.rapture.aquatic.client.render.hud.HudRender;
import com.github.rapture.aquatic.client.render.hud.IHudSupport;
import com.github.rapture.aquatic.init.AquaticBlocks;
import com.github.rapture.aquatic.init.AquaticItems;
import com.github.rapture.aquatic.item.armor.ScubaSuit;
import com.github.rapture.aquatic.tileentity.TileAquaNetController;
import com.github.rapture.aquatic.util.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileAquaNode
extends TileEntityBase
implements IHudSupport,
ITickable {
    public static final int sqRange = 900;
    public OxygenHandler oxygen = new OxygenHandler(10000);
    public BlockPos controllerPos = null;
    public int beamRenderTicks;
    private boolean hasAquaController = false;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.oxygen.readFromNBT(nbt);
        this.hasAquaController = nbt.func_74767_n("hasAquaController");
        if (nbt.func_74764_b("contx") && nbt.func_74764_b("conty") && nbt.func_74764_b("contz")) {
            this.controllerPos = new BlockPos(nbt.func_74762_e("contx"), nbt.func_74762_e("conty"), nbt.func_74762_e("contz"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.oxygen.writeToNBT(nbt);
        nbt.func_74757_a("hasAquaController", this.hasAquaController());
        if (this.controllerPos != null) {
            nbt.func_74768_a("contx", this.controllerPos.func_177958_n());
            nbt.func_74768_a("conty", this.controllerPos.func_177956_o());
            nbt.func_74768_a("contz", this.controllerPos.func_177952_p());
        }
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        ++this.beamRenderTicks;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState cuurentState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, cuurentState, cuurentState, 3);
        if (!this.hasAquaController()) {
            if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                return;
            }
            for (BlockPos bp : BlockPos.func_191532_a((int)(this.field_174879_c.func_177958_n() - 15), (int)(this.field_174879_c.func_177956_o() - 15), (int)(this.field_174879_c.func_177952_p() - 15), (int)(this.field_174879_c.func_177958_n() + 15), (int)(this.field_174879_c.func_177956_o() + 15), (int)(this.field_174879_c.func_177952_p() + 15))) {
                IBlockState state = this.field_145850_b.func_180495_p(bp);
                if (this.field_145850_b.func_175623_d(bp) || state.func_177230_c() != AquaticBlocks.AQUANET_CONTROLLER) continue;
                this.controllerPos = bp;
                this.setHasAquaController(true);
            }
        } else if (this.controllerPos != null && this.field_145850_b.func_175625_s(this.controllerPos) != null) {
            if (!(this.field_145850_b.func_175625_s(this.controllerPos) instanceof TileAquaNetController)) {
                this.setHasAquaController(false);
                return;
            }
            TileAquaNetController controller = (TileAquaNetController)this.field_145850_b.func_175625_s(this.controllerPos);
            if (controller.oxygen.canSendOxygen(20) && this.oxygen.canReceiveOxygen(20)) {
                controller.oxygen.drainOxygen(20);
                this.oxygen.fillOxygen(20);
                this.func_70296_d();
                controller.func_70296_d();
            }
        } else {
            this.setHasAquaController(false);
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            List<EntityPlayer> playerList = this.playersInRange();
            if (playerList.size() > 0) {
                // empty if block
            }
            for (EntityPlayer player : playerList) {
                if (!player.func_70090_H() || player.field_71075_bZ.field_75098_d) continue;
                this.sendPlayerAir(player);
            }
        }
    }

    public List<EntityPlayer> playersInRange() {
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, this.getRadius(this.func_174877_v(), 60, 60));
        ArrayList<EntityPlayer> rangePlayer = new ArrayList<EntityPlayer>();
        for (EntityPlayer player : players) {
            if (!(player.func_174818_b(this.field_174879_c) <= 900.0)) continue;
            rangePlayer.add(player);
        }
        return rangePlayer;
    }

    public void sendPlayerAir(EntityPlayer player) {
        if (player.func_70086_ai() < 300 && this.oxygen.canSendOxygen(300) && this.hasFullArmor(player)) {
            ScubaSuit suit = (ScubaSuit)player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b();
            suit.oxygenStorage.fillOxygen(300);
            this.oxygen.drainOxygen(300);
            player.func_70050_g(player.func_70086_ai() + 30);
            this.func_70296_d();
        }
    }

    public boolean hasFullArmor(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == AquaticItems.SCUBA_HELEMT && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == AquaticItems.SCUBA_CHEST && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == AquaticItems.SCUBA_LEGGINGS && (player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == AquaticItems.SCUBA_FEET || player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == AquaticItems.HEAVY_IRON_BOOTS);
    }

    @Override
    public EnumFacing getBlockOrientation() {
        return HudRender.getOrientationHoriz(this.func_145832_p());
    }

    @Override
    public String getDisplay() {
        return "Oxygen: " + this.oxygen.getOxygenStored();
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return (T)this.oxygen;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasAquaController() {
        return this.hasAquaController;
    }

    public void setHasAquaController(boolean hasAquaController) {
        this.hasAquaController = hasAquaController;
        this.func_70296_d();
    }
}

