/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.tileentity;

import com.github.rapture.aquatic.api.oxygen.OxygenHandler;
import com.github.rapture.aquatic.api.oxygen.capability.CapabilityOxygen;
import com.github.rapture.aquatic.client.render.hud.HudRender;
import com.github.rapture.aquatic.client.render.hud.IHudSupport;
import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.entity.misc.EntityWaterBubble;
import com.github.rapture.aquatic.init.AquaticBlocks;
import com.github.rapture.aquatic.util.CustomEnergyStorage;
import com.github.rapture.aquatic.util.TileEntityBase;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileAquaNetController
extends TileEntityBase
implements IHudSupport,
ITickable {
    public OxygenHandler oxygen = new OxygenHandler(10000);
    public int energyToGenerate = 20;
    public int spawnTimer = 0;
    private CustomEnergyStorage storage = new CustomEnergyStorage(100000);
    private boolean generatingOxygen = false;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setGeneratingOxygen(nbt.func_74767_n("generatingOxygen"));
        this.storage.readFromNBT(nbt);
        this.oxygen.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("generatingOxygen", this.isGeneratingOxygen());
        this.storage.writeToNBT(nbt);
        this.oxygen.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == AquaticBlocks.OXYGEN_STONE) {
            if (this.isGeneratingOxygen()) {
                ++this.spawnTimer;
                if (this.spawnTimer % 20 == 0) {
                    EntityWaterBubble bubble = new EntityWaterBubble(this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(8), this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(8), this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(8)));
                    EntityWaterBubble bubble2 = new EntityWaterBubble(this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n() - this.field_145850_b.field_73012_v.nextInt(8), this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(8), this.field_174879_c.func_177952_p() - this.field_145850_b.field_73012_v.nextInt(8)));
                    this.field_145850_b.func_72838_d((Entity)bubble);
                    this.field_145850_b.func_72838_d((Entity)bubble2);
                }
            }
            if (this.oxygen.canReceiveOxygen(AquaticConfig.aquaNetGeneration)) {
                if (this.storage.getEnergyStored() >= this.energyToGenerate) {
                    this.storage.extractEnergy(this.energyToGenerate, false);
                    this.oxygen.fillOxygen(AquaticConfig.aquaNetGeneration);
                    this.setGeneratingOxygen(true);
                } else {
                    this.setGeneratingOxygen(false);
                }
            } else {
                this.setGeneratingOxygen(false);
            }
        } else {
            this.setGeneratingOxygen(false);
        }
    }

    @Override
    public EnumFacing getBlockOrientation() {
        return HudRender.getOrientationHoriz(this.func_145832_p());
    }

    @Override
    public String getDisplay() {
        return this.storage.getEnergyStored() + " FE " + this.oxygen.getOxygenStored() + " Oxygen";
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
        }
        if (capability == CapabilityOxygen.OXYGEN_CAPABILITY) {
            return (T)CapabilityOxygen.OXYGEN_CAPABILITY.cast((Object)this.oxygen);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isGeneratingOxygen() {
        return this.generatingOxygen;
    }

    public void setGeneratingOxygen(boolean generatingOxygen) {
        this.generatingOxygen = generatingOxygen;
        this.func_70296_d();
    }
}

