/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.item.tool;

import com.github.rapture.aquatic.Aquatic;
import com.github.rapture.aquatic.util.CustomEnergyStorage;
import com.github.rapture.aquatic.util.NameUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.energy.CapabilityEnergy;

public class HydroDrill
extends ItemTool {
    public static final Item.ToolMaterial hydro_drill = EnumHelper.addToolMaterial((String)"hydro_drill", (int)3, (int)1561, (float)8.0f, (float)3.0f, (int)10);
    private CustomEnergyStorage energyStorage = new CustomEnergyStorage(100000);

    public HydroDrill() {
        super(1.0f, -2.8f, hydro_drill, Collections.emptySet());
        NameUtil.name((Item)this, "hydro_drill");
        this.func_77637_a(Aquatic.CREATIVE_TAB);
        this.setHarvestLevel("pickaxe", 3);
        this.setHarvestLevel("axe", 3);
        this.setHarvestLevel("shovel", 3);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 30.0f;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getDamage(ItemStack stack) {
        return this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void setDamage(ItemStack stack, int damage) {
        this.energyStorage.setEnergyStored(this.energyStorage.getEnergyStored() - this.energyStorage.getEnergyStored() - damage);
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityEnergy.ENERGY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)HydroDrill.this.energyStorage) : null);
            }
        };
    }
}

