/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.creativetab;

import com.github.rapture.aquatic.Aquatic;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CreativeTab
extends CreativeTabs {
    protected static final String BACKGROUND_IMAGE_SEARCHBAR = "item_search.png";
    private ItemStack icon = ItemStack.field_190927_a;
    private boolean hasSearchBar = false;
    private boolean displayRandom = true;
    private NonNullList<ItemStack> displayStacks = NonNullList.func_191196_a();

    public CreativeTab(String label, boolean searchBarEnabled) {
        super(label + ".name");
        this.hasSearchBar = searchBarEnabled;
        if (searchBarEnabled) {
            this.func_78025_a(BACKGROUND_IMAGE_SEARCHBAR);
        }
    }

    public CreativeTab(String label) {
        this(label, false);
    }

    public void setHasSearchBar(boolean hasSearchBar) {
        this.hasSearchBar = hasSearchBar;
    }

    public void setDisplayFromList(NonNullList<ItemStack> displayList) {
        Preconditions.checkNotNull(displayList);
        this.displayStacks = displayList;
        this.displayRandom = true;
    }

    public void setIcon(ItemStack icon) {
        if (icon.func_190926_b()) {
            this.displayRandom = true;
        } else {
            this.displayRandom = false;
            icon.func_190920_e(1);
        }
        this.icon = icon;
    }

    public void setIcon(Item item) {
        this.setIcon(new ItemStack(item));
    }

    public void setIcon(Block block) {
        this.setIcon(new ItemStack(block));
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_151244_d() {
        this.updateDisplayStack();
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateDisplayStack() {
        if (this.icon.func_190926_b() || this.displayRandom && Minecraft.func_71386_F() % 120L == 0L) {
            if (this.displayStacks.isEmpty()) {
                this.func_78018_a(this.displayStacks);
            }
            this.icon = ItemStack.field_190927_a;
            if (!this.displayStacks.isEmpty()) {
                try {
                    for (int i = 0; i < this.displayStacks.size(); ++i) {
                        ItemStack listStack = (ItemStack)this.displayStacks.get(i);
                        if (listStack.func_190926_b() || !listStack.func_77969_a(this.icon)) continue;
                        int nextIndex = i + 1;
                        if (nextIndex > this.displayStacks.size()) {
                            nextIndex = 0;
                        }
                        this.icon = (ItemStack)this.displayStacks.get(nextIndex);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.icon.func_190926_b()) {
                Aquatic.getLogger().warn("found empty Itemstack for CreativeTab " + this.func_78013_b() + ", defaulting to " + Items.field_151045_i.getRegistryName());
                this.icon = new ItemStack(Items.field_151045_i);
                this.displayRandom = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_78016_d() {
        return this.func_151244_d();
    }
}

