/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.client.render;

import com.github.rapture.aquatic.client.render.hud.HudRender;
import com.github.rapture.aquatic.config.AquaticConfig;
import com.github.rapture.aquatic.tileentity.TileAquaNetController;
import com.github.rapture.aquatic.tileentity.TileAquaNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderAquaNode
extends TileEntitySpecialRenderer<TileAquaNode> {
    private static final ResourceLocation OXYGEN_BEAM = new ResourceLocation("aquatic", "textures/entity/oxygen_beam.png");
    private static final ResourceLocation BUBBLE = new ResourceLocation("aquatic", "textures/entity/bubble.png");
    private Minecraft mc = Minecraft.func_71410_x();

    public void render(TileAquaNode te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntity controllerTe;
        BlockPos blockPos = te.func_174877_v();
        HudRender.renderHud(te, x, y, z);
        if (te.controllerPos != null && te.hasAquaController() && (controllerTe = te.func_145831_w().func_175625_s(te.controllerPos)) != null && controllerTe instanceof TileAquaNetController) {
            TileAquaNetController controller = (TileAquaNetController)controllerTe;
            double sX = (double)(te.controllerPos.func_177958_n() - blockPos.func_177958_n()) + x + 0.5;
            double sY = (double)(te.controllerPos.func_177956_o() - blockPos.func_177956_o()) + y + 0.5;
            double sZ = (double)(te.controllerPos.func_177952_p() - blockPos.func_177952_p()) + z + 0.5;
            this.renderBeam(sX, sY, sZ, x + 0.5, y + 0.625, z + 0.5, te.beamRenderTicks, partialTicks, te.oxygen.getOxygenStored() != te.oxygen.getMaxOxygenStorage() && controller.oxygen.canSendOxygen(20));
        }
        if (AquaticConfig.aquaNodeBeam && te.oxygen.getOxygenStored() != 0 && te.playersInRange() != null) {
            for (EntityPlayer player : te.playersInRange()) {
                if (!te.hasFullArmor(player)) continue;
                Vec3d pPos = player.func_174791_d();
                double dX = player.field_70165_t - player.field_70142_S;
                double dY = player.field_70163_u - player.field_70137_T;
                double dZ = player.field_70161_v - player.field_70136_U;
                float invAlpha = 1.0f - partialTicks;
                double pX = (double)blockPos.func_177958_n() - pPos.field_72450_a - x + dX * (double)invAlpha;
                double pY = (double)blockPos.func_177956_o() - pPos.field_72448_b - y + dY * (double)invAlpha - (double)(player.field_70131_O / 2.0f);
                double pZ = (double)blockPos.func_177952_p() - pPos.field_72449_c - z + dZ * (double)invAlpha;
                this.renderBeam(x + 0.5, y + 0.625, z + 0.5, -pX, -pY, -pZ, te.beamRenderTicks, partialTicks, true);
            }
        }
    }

    private void renderBeam(double x1, double y1, double z1, double x2, double y2, double z2, int ticks, double partialTicks, boolean renderBubbles) {
        double bubbleProg;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.func_147499_a(OXYGEN_BEAM);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        float f1 = 240.0f;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float timing = (float)((double)ticks + partialTicks);
        float f3 = timing * 0.3f % 1.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x2), (float)((float)y2), (float)((float)z2));
        Vec3d vec3d = new Vec3d(x1, y1, z1);
        Vec3d vec3d1 = new Vec3d(x2, y2, z2);
        Vec3d beamDirection = vec3d.func_178788_d(vec3d1);
        double beamLength = beamDirection.func_72433_c();
        beamDirection = beamDirection.func_72432_b();
        float f5 = (float)Math.acos(beamDirection.field_72448_b);
        float f6 = (float)Math.atan2(beamDirection.field_72449_c, beamDirection.field_72450_a);
        GlStateManager.func_179114_b((float)((1.5707964f + -f6) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        double d1 = (double)timing * 0.05 * -1.5;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        int r1 = 104;
        int g1 = 217;
        int b1 = 255;
        int r2 = 8;
        int g2 = 193;
        int b2 = 255;
        double d2 = 0.2;
        double d3 = 0.282;
        double d4 = 0.0 + Math.cos(d1 + 2.356194490192345) * 0.282;
        double d5 = 0.0 + Math.sin(d1 + 2.356194490192345) * 0.282;
        double d6 = 0.0 + Math.cos(d1 + 0.7853981633974483) * 0.282;
        double d7 = 0.0 + Math.sin(d1 + 0.7853981633974483) * 0.282;
        double d8 = 0.0 + Math.cos(d1 + 3.9269908169872414) * 0.282;
        double d9 = 0.0 + Math.sin(d1 + 3.9269908169872414) * 0.282;
        double d10 = 0.0 + Math.cos(d1 + 5.497787143782138) * 0.282;
        double d11 = 0.0 + Math.sin(d1 + 5.497787143782138) * 0.282;
        double d12 = 0.0 + Math.cos(d1 + Math.PI) * 0.2;
        double d13 = 0.0 + Math.sin(d1 + Math.PI) * 0.2;
        double d14 = 0.0 + Math.cos(d1 + 0.0) * 0.2;
        double d15 = 0.0 + Math.sin(d1 + 0.0) * 0.2;
        double d16 = 0.0 + Math.cos(d1 + 1.5707963267948966) * 0.2;
        double d17 = 0.0 + Math.sin(d1 + 1.5707963267948966) * 0.2;
        double d18 = 0.0 + Math.cos(d1 + 4.71238898038469) * 0.2;
        double d19 = 0.0 + Math.sin(d1 + 4.71238898038469) * 0.2;
        double d20 = 0.0;
        double d21 = 0.4999;
        double d22 = -1.0f + f3;
        double d23 = beamLength * 2.5 + d22;
        bufferbuilder.func_181662_b(d12, beamLength, d13).func_187315_a(0.4999, d23).func_181669_b(r1, g1, b1, 255).func_181675_d();
        bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(0.4999, d22).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d14, beamLength, d15).func_187315_a(0.0, d23).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d16, beamLength, d17).func_187315_a(0.4999, d23).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(0.4999, d22).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(r2, g2, b2, 255).func_181675_d();
        bufferbuilder.func_181662_b(d18, beamLength, d19).func_187315_a(0.0, d23).func_181669_b(r1, g1, b1, 255).func_181675_d();
        double d24 = 0.0;
        bufferbuilder.func_181662_b(d4, beamLength, d5).func_187315_a(0.5, d24 + 0.5).func_181669_b(r1, g1, b1, 255).func_181675_d();
        bufferbuilder.func_181662_b(d6, beamLength, d7).func_187315_a(1.0, d24 + 0.5).func_181669_b(r1, g1, b1, 255).func_181675_d();
        bufferbuilder.func_181662_b(d10, beamLength, d11).func_187315_a(1.0, d24).func_181669_b(r1, g1, b1, 255).func_181675_d();
        bufferbuilder.func_181662_b(d8, beamLength, d9).func_187315_a(0.5, d24).func_181669_b(r1, g1, b1, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        if (!renderBubbles) {
            return;
        }
        this.func_147499_a(BUBBLE);
        Vec3d origin = new Vec3d(x1, y1, z1);
        float bubbleDist = 1.0f;
        int i = 0;
        while ((double)i <= beamLength / (double)bubbleDist && !((bubbleProg = (double)timing * 0.1 % (double)bubbleDist + (double)((float)i * bubbleDist)) > beamLength)) {
            Vec3d bubbleLoc = origin.func_178787_e(beamDirection.func_186678_a(-bubbleProg));
            this.renderBubble(bubbleLoc.field_72450_a, bubbleLoc.field_72448_b, bubbleLoc.field_72449_c);
            ++i;
        }
    }

    public void renderBubble(double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179084_k();
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        GlStateManager.func_179114_b((float)(180.0f - this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.mc.func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.mc.func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.16f, (float)0.16f, (float)0.16f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TileAquaNode te) {
        return true;
    }
}

