/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.client.guide;

import com.github.rapture.aquatic.Aquatic;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class GuideReader {
    public static final TreeMap<String, NBTTagCompound> GUIDE_INDEX = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    public static final Map<String, Integer> CHILD_COUNT = new HashMap<String, Integer>();
    private static final ResourceLocation INDEX_PAGE = new ResourceLocation("aquatic", "index.json");
    private static final Map<String, String> PAGES = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NBTTagCompound readJsonToNbt(@Nullable ResourceLocation location) {
        if (location == null) return new NBTTagCompound();
        String path = ("/assets/" + location.func_110624_b() + "/pages/" + location.func_110623_a()).toLowerCase(Locale.ROOT);
        if (!path.endsWith(".json")) {
            path = path + ".json";
        }
        try (Scanner sc = new Scanner(new BufferedInputStream(MinecraftServer.class.getResourceAsStream(path)));){
            StringBuilder builder = new StringBuilder();
            while (sc.hasNext()) {
                builder.append(sc.next());
            }
            NBTTagCompound nBTTagCompound = JsonToNBT.func_180713_a((String)builder.toString());
            return nBTTagCompound;
        }
        catch (Exception e) {
            Aquatic.getLogger().error("Exception reading " + location + ", defaulting to empty page!");
        }
        return new NBTTagCompound();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readPage(String page) {
        if (page != null && PAGES.containsKey(page)) {
            ResourceLocation location = new ResourceLocation(PAGES.get(page));
            String path = ("/assets/" + location.func_110624_b() + "/pages/" + Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a() + "/" + location.func_110623_a()).toLowerCase(Locale.ROOT);
            if (!path.endsWith(".md")) {
                path = path + ".md";
            }
            try (BufferedInputStream stream = new BufferedInputStream(MinecraftServer.class.getResourceAsStream(path));){
                String output = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8);
                List<String> arrayList = Arrays.asList(output.split("\r\n"));
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                try (Scanner sc = new Scanner(new BufferedInputStream(MinecraftServer.class.getResourceAsStream(path)));){
                    StringBuilder builder = new StringBuilder();
                    while (sc.hasNext()) {
                        builder.append(sc.next());
                    }
                    ArrayList arrayList = Lists.newArrayList((Object[])new String[]{builder.toString()});
                    return arrayList;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        Aquatic.getLogger().error("Exception reading {}, defaulting to empty page!", (Object)page);
        return Collections.emptyList();
    }

    public static void init() {
        NBTTagCompound indexNBT = GuideReader.readJsonToNbt(INDEX_PAGE);
        NBTTagList topics = indexNBT.func_150295_c("index", 10);
        for (int i = 0; i < topics.func_74745_c(); ++i) {
            NBTTagCompound compound = topics.func_150305_b(i);
            String id = compound.func_74779_i("id");
            GUIDE_INDEX.put(id, compound);
            PAGES.put(id, compound.func_74779_i("page"));
            if (compound.func_150297_b("child_elements", 9)) {
                NBTTagList tagList = compound.func_150295_c("child_elements", 10);
                CHILD_COUNT.put(id, tagList.func_74745_c());
                for (int j = 0; j < tagList.func_74745_c(); ++j) {
                    NBTTagCompound child = tagList.func_150305_b(j);
                    PAGES.put(child.func_74779_i("id"), child.func_74779_i("page"));
                }
                continue;
            }
            CHILD_COUNT.put(id, 0);
        }
    }
}

