/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.client.gui;

import com.github.rapture.aquatic.client.gui.EnumFontType;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiScrollableList
extends Gui {
    public static final int SCROLL_BAR_BG_COLOR = new Color(128, 128, 128).getRGB();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final int BOUNDARY_COLOR = new Color(50, 230, 230).getRGB();
    private static final int BACKGROUND_COLOR = new Color(0, 0, 0).getRGB();
    private static final int SCROLL_BAR_COLOR = new Color(120, 200, 200).getRGB();
    private static final int SCROLL_FACTOR = 3;
    private final List<String> textLines = Lists.newArrayList();
    private int TEXT_MARGIN = 4;
    private int TEXT_HEIGHT = 2;
    private int SCROLLBAR_WIDTH = 10;
    private int x;
    private int y;
    private int width;
    private int height;
    private int currentIndex;
    private int maxIndex;
    private int maxLinesOnScreen;
    private FontRenderer fontRenderer;
    private int timePressed;
    private boolean isMouseDraggingScrollBar;
    private int prevMouseY;

    public GuiScrollableList(int x, int y, int width, int height, List<String> text) {
        this.fontRenderer = GuiScrollableList.mc.field_71466_p;
        this.timePressed = 0;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        text.forEach(s -> {
            int spaces = 0;
            while (s.startsWith(">")) {
                s = s.substring(1);
                spaces += 2;
            }
            this.addLines(spaces, (String)s);
        });
        this.currentIndex = 0;
        int tempHeadingHeightOffset = EnumFontType.HEADING_1.getFontHeight() - EnumFontType.DEFAULT.getFontHeight();
        this.maxLinesOnScreen = (height - this.TEXT_MARGIN * 2 - tempHeadingHeightOffset) / (this.fontRenderer.field_78288_b + this.TEXT_HEIGHT);
        this.maxIndex = Math.max(0, this.textLines.size() - this.maxLinesOnScreen);
    }

    public void addLines(int marginSpaces, String ... text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < marginSpaces; ++i) {
            builder.append(" ");
        }
        String indent = builder.toString();
        int maxWidth = this.width - this.TEXT_MARGIN * 2 - this.fontRenderer.func_78256_a(indent) - this.SCROLLBAR_WIDTH - 1;
        for (String line : text) {
            this.fontRenderer.func_78271_c(line, maxWidth).forEach(s -> this.textLines.add(indent + s));
        }
        this.maxIndex = Math.max(0, this.textLines.size() - this.maxLinesOnScreen);
        this.currentIndex = MathHelper.func_76125_a((int)this.currentIndex, (int)0, (int)this.maxIndex);
    }

    public void handleMouseInput() {
        int amount = Mouse.getEventDWheel();
        if (amount != 0) {
            amount = amount > 0 ? -1 : 1;
            this.scroll(amount);
        }
    }

    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.isMouseDraggingScrollBar) {
            int diff = mouseY - this.prevMouseY;
            int scrollbarHeight = (int)((float)this.maxLinesOnScreen / (float)this.textLines.size() * (float)this.height);
            int maxDiff = scrollbarHeight / (this.textLines.size() - this.maxLinesOnScreen);
            if (diff > maxDiff) {
                this.scroll(1);
            } else if (diff < -maxDiff) {
                this.scroll(-1);
            }
            this.prevMouseY = mouseY;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.isMouseDraggingScrollBar) {
            this.isMouseDraggingScrollBar = false;
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textLines.size() > this.maxLinesOnScreen) {
            int scrollbarX = this.x + this.width - this.SCROLLBAR_WIDTH - 1;
            int scrollbarHeight = (int)((float)this.maxLinesOnScreen / (float)this.textLines.size() * (float)this.height) - 2;
            int scrollOffset = (int)((float)this.currentIndex / (float)(this.textLines.size() - this.maxLinesOnScreen) * (float)(this.height - scrollbarHeight));
            int scrollbarY = this.y + scrollOffset;
            if (mouseX >= scrollbarX && this.x <= scrollbarX + this.SCROLLBAR_WIDTH - 1 && mouseY >= scrollbarY && mouseY <= scrollbarY + scrollbarHeight) {
                this.isMouseDraggingScrollBar = true;
                this.prevMouseY = mouseY;
            }
        }
    }

    public void keyTyped(char typedChar, int keyCode) {
        int scrollAmount = 0;
        if (keyCode == 208) {
            scrollAmount = 1;
        } else if (keyCode == 200) {
            scrollAmount = -1;
        }
        this.scroll(scrollAmount);
    }

    protected void scroll(int rawAmount) {
        if (this.textLines.size() > this.maxLinesOnScreen) {
            this.currentIndex = MathHelper.func_76125_a((int)(this.currentIndex + rawAmount * 3), (int)0, (int)this.maxIndex);
        }
    }

    public void draw() {
        GuiScrollableList.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)BOUNDARY_COLOR);
        GuiScrollableList.func_73734_a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.width - 1), (int)(this.y + this.height - 1), (int)BACKGROUND_COLOR);
        for (int i = this.currentIndex; i < Math.min(this.maxLinesOnScreen + this.currentIndex, this.textLines.size()); ++i) {
            int index = i - this.currentIndex;
            EnumFontType fontType = EnumFontType.DEFAULT;
            if (index == 0) {
                fontType = EnumFontType.HEADING_1;
            }
            this.fontRenderer.field_78288_b = fontType.getFontHeight();
            this.fontRenderer.func_78276_b(this.textLines.get(i), this.x + this.TEXT_MARGIN, this.y + this.TEXT_MARGIN + (this.fontRenderer.field_78288_b + this.TEXT_HEIGHT) * index, fontType.getFontColor());
            this.fontRenderer.field_78288_b = 9;
        }
        if (this.textLines.size() > this.maxLinesOnScreen) {
            int scrollbarHeight = (int)((float)this.maxLinesOnScreen / (float)this.textLines.size() * (float)this.height) - 2;
            int scrollOffset = Math.max(0, (int)((float)this.currentIndex / (float)(this.textLines.size() - this.maxLinesOnScreen) * (float)(this.height - scrollbarHeight)));
            GuiScrollableList.func_73734_a((int)(this.x + this.width - this.SCROLLBAR_WIDTH - 1), (int)(this.y + 1), (int)(this.x + this.width - 1), (int)(this.y + this.height - 1), (int)SCROLL_BAR_BG_COLOR);
            GuiScrollableList.func_73734_a((int)(this.x + this.width - this.SCROLLBAR_WIDTH - 1), (int)(this.y + scrollOffset + 1), (int)(this.x + this.width - 1), (int)(this.y + scrollbarHeight + scrollOffset - 1), (int)SCROLL_BAR_COLOR);
        }
    }

    public void update() {
        boolean key_down = Keyboard.isKeyDown((int)208);
        if (key_down || Keyboard.isKeyDown((int)200)) {
            if (this.timePressed > 10) {
                if (key_down) {
                    this.scroll(1);
                } else {
                    this.scroll(-1);
                }
            }
            ++this.timePressed;
        } else {
            this.timePressed = 0;
        }
    }
}

