/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.client.gui;

import com.github.rapture.aquatic.client.gui.GuiScrollableList;
import com.github.rapture.aquatic.client.guide.GuideReader;
import java.io.IOException;
import java.util.List;
import jline.internal.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class GuiScreenGuide
extends GuiScreen {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 40;
    private static final int MARGIN_SIDE = 30;
    private static final int INDEX_WIDTH = 160;
    private static final int INDEX_HEIGHT = 18;
    private static final int INDEX_MARGIN = 2;
    private static final int ENTRY_MARGIN = 4;
    private static final int CYAN = 820438271;
    private static final int BLACK = 255;
    private static final int LIGHT_GRAY = -2139062017;
    private static String lastEntry = null;
    private static String lastChild = null;
    private GuiScrollableList textBox;
    private String selectedEntry;
    private String selectedChild = null;

    private GuiScreenGuide(@Nullable ResourceLocation selectedPage) {
        if (selectedPage != null) {
            this.selectedEntry = selectedPage.toString();
        } else {
            this.selectedEntry = lastEntry;
            this.selectedChild = lastChild;
        }
    }

    public static void openPage(@Nullable ResourceLocation page) {
        if (GuiScreenGuide.MC.field_71462_r instanceof GuiScreenGuide) {
            ((GuiScreenGuide)GuiScreenGuide.MC.field_71462_r).setSelected(page != null ? page.toString() : null);
        } else {
            MC.func_147108_a((GuiScreen)new GuiScreenGuide(page));
        }
    }

    public void func_146281_b() {
        lastEntry = this.selectedEntry;
        lastChild = this.selectedChild;
    }

    public void setSelected(@Nullable String entry) {
        if (entry == null || GuideReader.GUIDE_INDEX.containsKey(entry)) {
            this.selectedEntry = entry != null && entry.equals(this.selectedEntry) ? null : entry;
            this.selectedChild = null;
        } else {
            boolean hasKey = false;
            block0: for (String key : GuideReader.GUIDE_INDEX.keySet()) {
                if (GuideReader.CHILD_COUNT.get(key) <= 0) continue;
                NBTTagList tagList = GuideReader.GUIDE_INDEX.get(key).func_150295_c("child_elements", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    if (!entry.equals(tagList.func_150305_b(i).func_74779_i("id"))) continue;
                    this.selectedEntry = key;
                    this.selectedChild = entry;
                    hasKey = true;
                    break block0;
                }
            }
            if (!hasKey) {
                this.selectedEntry = null;
                this.selectedChild = null;
            }
        }
        this.func_73866_w_();
    }

    public void func_73866_w_() {
        List<String> lines = GuideReader.readPage(this.selectedChild != null ? this.selectedChild : this.selectedEntry);
        this.textBox = new GuiScrollableList(198, 24, this.field_146294_l - 60 - 4 - 160 - 12, this.field_146295_m - 20 - 40 - 16, lines);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textBox.update();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        GuiScreenGuide.func_73734_a((int)29, (int)19, (int)(this.field_146294_l - 30 + 1), (int)(this.field_146295_m - 40 + 1), (int)820438271);
        GuiScreenGuide.func_73734_a((int)30, (int)20, (int)(this.field_146294_l - 30), (int)(this.field_146295_m - 40), (int)255);
        int x = 33;
        int y = 25;
        GuiScreenGuide.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 160), (int)y, (int)255);
        for (String key : GuideReader.GUIDE_INDEX.keySet()) {
            NBTTagCompound entryNBT = GuideReader.GUIDE_INDEX.get(key);
            this.drawEntry(x, y, 160, 18, entryNBT);
            y += 19;
            if (!key.equals(this.selectedEntry) || !entryNBT.func_150297_b("child_elements", 9)) continue;
            NBTTagList childElements = entryNBT.func_150295_c("child_elements", 10);
            for (int i = 0; i < childElements.func_74745_c(); ++i) {
                NBTTagCompound childEntryNBT = childElements.func_150305_b(i);
                this.drawEntry(x + 2, y, 158, 18, childEntryNBT);
                y += 19;
            }
        }
        this.textBox.draw();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawEntry(int x, int y, int width, int height, NBTTagCompound entry) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiScreenGuide.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)-2139062017);
        GuiScreenGuide.func_73734_a((int)x, (int)(y + height), (int)(x + width), (int)(y + height + 1), (int)255);
        if (entry.func_150297_b("icon", 8)) {
            try {
                RenderHelper.func_74520_c();
                Item item = Item.func_111206_d((String)entry.func_74779_i("icon"));
                if (item != null) {
                    MC.func_175599_af().func_175042_a(new ItemStack(item), x, y);
                }
                RenderHelper.func_74518_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiScreenGuide.MC.field_71466_p.func_78276_b(I18n.func_135052_a((String)("entry." + entry.func_74779_i("id").replace(":", ".") + ".caption"), (Object[])new Object[0]), x + 20, y + (18 - GuiScreenGuide.MC.field_71466_p.field_78288_b) / 2 + 1, 255);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.textBox.handleMouseInput();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textBox.mouseClicked(mouseX, mouseY, mouseButton);
        int xPos = 33;
        if (mouseX >= xPos && mouseX <= xPos + 160) {
            this.setSelected(this.getIndexAtPos(mouseY));
        }
    }

    @Nullable
    private String getIndexAtPos(int yPos) {
        int y = 25;
        if (yPos >= y) {
            for (String key : GuideReader.GUIDE_INDEX.keySet()) {
                if ((y += 19) > yPos) {
                    return key;
                }
                if (!key.equals(this.selectedEntry)) continue;
                for (int i = 0; i < GuideReader.CHILD_COUNT.get(key); ++i) {
                    if ((y += 19) <= yPos) continue;
                    return GuideReader.GUIDE_INDEX.get(key).func_150295_c("child_elements", 10).func_150305_b(i).func_74779_i("id");
                }
            }
        }
        return null;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.textBox.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.textBox.mouseReleased(mouseX, mouseY, state);
    }
}

