/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.client;

import com.github.rapture.aquatic.Aquatic;
import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientUtil {
    public static void openLink(String url) {
        try {
            URI uri = new URI(url);
            Class<?> oclass = Class.forName("java.awt.Desktop");
            boolean flag = (Boolean)oclass.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
            if (!flag) {
                throw new UnsupportedOperationException("no desktop supported!");
            }
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, uri);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Object[] objectArray = new Object[1];
            objectArray[0] = throwable == null ? (StringUtils.func_151246_b((String)url) ? "<UNKNOWN>" : url) : throwable.getMessage();
            Aquatic.getLogger().error("Couldn't open link: {}", objectArray);
        }
    }

    public static ResourceLocation loadTexture(ResourceLocation location, int[] data) {
        ResourceLocation dest;
        Preconditions.checkArgument((data.length == 2 ? 1 : 0) != 0, (Object)"Data pointer must have an array size of 2");
        try {
            BufferedImage img = TextureUtil.func_177053_a((InputStream)ClientUtil.class.getResourceAsStream("/assets/" + location.func_110624_b() + "/" + location.func_110623_a()));
            data[0] = img.getWidth();
            data[1] = img.getHeight();
            dest = Minecraft.func_71410_x().func_110434_K().func_110578_a(location.func_110624_b(), new DynamicTexture(img));
        }
        catch (Exception e) {
            dest = TextureMap.field_174945_f;
            Aquatic.getLogger().warn("Image not found:" + location);
        }
        return dest;
    }

    public static KeyBinding getKeyBinding(String name, int keyCode) {
        return new KeyBinding("key.aquatic." + name, keyCode, "key.category.aquatic");
    }
}

