/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.api.ph;

import com.github.rapture.aquatic.api.ph.IPHProvider;
import com.github.rapture.aquatic.api.ph.capability.CapabilityPH;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PHHandler
implements IPHProvider {
    private static final int MAX_PH = 10000;
    private int PH;

    public PHHandler() {
        this(0);
    }

    public PHHandler(int ph) {
        this.PH = ph;
    }

    @Override
    public void addPH(int amount) {
        this.PH = MathHelper.func_76125_a((int)(this.PH + amount), (int)0, (int)10000);
    }

    @Override
    public void drainPH(int amount) {
        this.addPH(-amount);
    }

    @Override
    public int getPHFromLocation(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        if (chunk.hasCapability(CapabilityPH.PH_CAPABILITY, null)) {
            return ((IPHProvider)world.func_175726_f(pos).getCapability(CapabilityPH.PH_CAPABILITY, null)).getPH();
        }
        return 0;
    }

    @Override
    public int getPH() {
        return this.PH;
    }

    @Override
    public void setPH(int amount) {
        this.PH = Math.max(0, amount);
    }

    @Override
    public int getMaxPH() {
        return 10000;
    }
}

