/*
 * Decompiled with CFR 0.152.
 */
package com.github.rapture.aquatic.api.oxygen;

import com.github.rapture.aquatic.api.oxygen.IOxygenProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class OxygenHandler
implements IOxygenProvider {
    private int oxygen = 0;
    private int maxOxygen;

    public OxygenHandler() {
        this(10000);
    }

    public OxygenHandler(int capacity) {
        this.maxOxygen = capacity;
    }

    public OxygenHandler(int capacity, int initialAmount) {
        this(capacity);
        this.setOxygen(initialAmount);
    }

    @Override
    public void setOxygen(int amount) {
        this.oxygen = MathHelper.func_76125_a((int)amount, (int)0, (int)this.maxOxygen);
    }

    @Override
    public void setStorageAmount(int amount) {
        this.maxOxygen = amount;
        this.oxygen = Math.min(this.oxygen, amount);
    }

    @Override
    public void fillOxygen(int amount) {
        this.oxygen = MathHelper.func_76125_a((int)(this.oxygen + amount), (int)0, (int)this.maxOxygen);
    }

    @Override
    public void drainOxygen(int amount) {
        this.fillOxygen(-amount);
    }

    @Override
    public boolean canReceiveOxygen(int amount) {
        return this.maxOxygen - this.oxygen >= amount;
    }

    @Override
    public boolean canSendOxygen(int amount) {
        return this.oxygen >= amount;
    }

    @Override
    public int getOxygenStored() {
        return this.oxygen;
    }

    @Override
    public int getMaxOxygenStorage() {
        return this.maxOxygen;
    }

    public OxygenHandler readFromNBT(NBTTagCompound nbt) {
        this.setOxygen(nbt.func_74762_e("oxygen"));
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("oxygen", this.oxygen);
        return nbt;
    }
}

