/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.utils.capability;

import com.wynprice.modjam5.common.utils.ByteBufHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class DataInfomation {
    public static final DataInfomation DEFAULT = new DataInfomation(-1, false, BlockPos.field_177992_a, new int[0]);
    private final int color;
    private final boolean isSpreadable;
    private final BlockPos origin;
    private int[] spreadTo = new int[0];

    public DataInfomation(int color, boolean isSpreadable, BlockPos origin, int[] spreadTo) {
        this.color = color;
        this.isSpreadable = isSpreadable;
        this.origin = origin;
        this.spreadTo = spreadTo;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isSpreadable() {
        return this.isSpreadable;
    }

    public final boolean isDefault() {
        return this == DEFAULT;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public int[] getSpreadTo() {
        return this.spreadTo;
    }

    public void addFace(EnumFacing face) {
        int[] aint = new int[this.spreadTo.length + 1];
        for (int i = 0; i < this.spreadTo.length; ++i) {
            aint[i] = this.spreadTo[i];
        }
        aint[this.spreadTo.length] = face.func_176745_a();
    }

    public static DataInfomation fromNBT(NBTTagCompound data) {
        return new DataInfomation(data.func_74762_e("color"), data.func_74767_n("doesSpread"), BlockPos.func_177969_a((long)data.func_74763_f("originPos")), data.func_74759_k("spreadTo"));
    }

    public static DataInfomation fromByteBuf(ByteBuf buf) {
        return new DataInfomation(buf.readInt(), buf.readBoolean(), BlockPos.func_177969_a((long)buf.readLong()), ByteBufHelper.readIntArray(buf));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("color", this.getColor());
        nbt.func_74757_a("doesSpread", this.isSpreadable());
        nbt.func_74772_a("originPos", this.getOrigin().func_177986_g());
        nbt.func_74783_a("spreadTo", this.getSpreadTo());
        return nbt;
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.getColor());
        buf.writeBoolean(this.isSpreadable());
        buf.writeLong(this.getOrigin().func_177986_g());
        ByteBufHelper.writeIntArray(buf, this.getSpreadTo());
    }
}

