/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.utils.capability;

import com.google.common.collect.Lists;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityHandler {
    @CapabilityInject(value=IDataInfomationProvider.class)
    public static Capability<IDataInfomationProvider> DATA_CAPABILITY = null;

    public static enum ColorStorage implements Capability.IStorage<IDataInfomationProvider>
    {
        INSTANCE;


        public NBTBase writeNBT(Capability<IDataInfomationProvider> capability, IDataInfomationProvider instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            for (BlockPos pos : instance.getMap().keySet()) {
                nbt.func_74782_a(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p(), (NBTBase)instance.getMap().get(pos).serializeNBT());
            }
            return nbt;
        }

        public void readNBT(Capability<IDataInfomationProvider> capability, IDataInfomationProvider instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            for (String key : tag.func_150296_c()) {
                NBTTagCompound data = tag.func_74775_l(key);
                BlockPos pos = new BlockPos(Integer.valueOf(key.split(" ")[0]).intValue(), Integer.valueOf(key.split(" ")[1]).intValue(), Integer.valueOf(key.split(" ")[2]).intValue());
                DataInfomation info = DataInfomation.fromNBT(data);
                instance.getMap().put(pos, info);
                instance.addPositionToOriginList(info.getOrigin(), pos);
            }
            instance.sync();
        }
    }

    public static class DefaultImpl
    implements IDataInfomationProvider {
        private final ConcurrentHashMap<BlockPos, DataInfomation> map = new ConcurrentHashMap();
        private final HashMap<BlockPos, List<BlockPos>> originMap = new HashMap();
        private boolean synced;

        @Override
        public synchronized Map<BlockPos, DataInfomation> getMap() {
            return this.map;
        }

        @Override
        public List<BlockPos> getPositionFromOrigin(BlockPos origin) {
            ArrayList list = this.originMap.get(origin);
            return list == null ? new ArrayList() : list;
        }

        @Override
        public void clear() {
            this.originMap.clear();
            this.map.clear();
        }

        @Override
        public void addPositionToOriginList(BlockPos origin, BlockPos pos) {
            List<BlockPos> list = this.originMap.get(origin);
            if (list == null) {
                this.originMap.put(origin, Lists.newArrayList((Object[])new BlockPos[]{pos}));
            } else {
                list.add(pos);
            }
        }

        @Override
        public void sync() {
            this.synced = true;
        }

        @Override
        public boolean hasSynced() {
            return this.synced;
        }
    }

    public static interface IDataInfomationProvider {
        public Map<BlockPos, DataInfomation> getMap();

        public List<BlockPos> getPositionFromOrigin(BlockPos var1);

        public void clear();

        public void addPositionToOriginList(BlockPos var1, BlockPos var2);

        public boolean hasSynced();

        public void sync();
    }

    public static class ColorCapabilityProvider
    implements ICapabilitySerializable<NBTBase> {
        private final DefaultImpl defaultImpl = new DefaultImpl();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == DATA_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == DATA_CAPABILITY) {
                return (T)this.defaultImpl;
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return ColorStorage.INSTANCE.writeNBT(DATA_CAPABILITY, this.defaultImpl, EnumFacing.UP);
        }

        public void deserializeNBT(NBTBase nbt) {
            ColorStorage.INSTANCE.readNBT(DATA_CAPABILITY, this.defaultImpl, EnumFacing.UP, nbt);
        }
    }
}

