/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.utils;

import com.wynprice.modjam5.common.colorfunctionality.ColorFunction;
import com.wynprice.modjam5.common.colorfunctionality.ColorFunctions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ColorUtils {
    public static int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color") & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public static ItemStack setColor(ItemStack itemstack, int color) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            itemstack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
        return itemstack;
    }

    public static ColorFunction calculateClosestColor(int color) {
        ArrayList<ColorFunction> acceptedFunction = new ArrayList<ColorFunction>();
        for (ColorFunction function : ColorFunctions.ALL_FUNCTIONS) {
            if (!function.shouldApply(Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, null))) continue;
            acceptedFunction.add(function);
        }
        if (acceptedFunction.contains(ColorFunctions.GRAY)) {
            return ColorFunctions.GRAY;
        }
        if (acceptedFunction.contains(ColorFunctions.WHITE)) {
            return ColorFunctions.WHITE;
        }
        if (acceptedFunction.contains(ColorFunctions.BLACK)) {
            return ColorFunctions.BLACK;
        }
        if (acceptedFunction.isEmpty()) {
            acceptedFunction.add(ColorFunctions.NONE);
        }
        return (ColorFunction)acceptedFunction.get(new Random().nextInt(acceptedFunction.size()));
    }
}

