/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.registries;

import com.google.common.collect.Lists;
import com.wynprice.modjam5.WorldPaint;
import com.wynprice.modjam5.common.items.ItemColorPicker;
import com.wynprice.modjam5.common.items.ItemPainingBoots;
import com.wynprice.modjam5.common.items.ItemPaint;
import com.wynprice.modjam5.common.items.ItemPaintBrush;
import com.wynprice.modjam5.common.items.ItemPaintScrubber;
import java.util.ArrayList;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="worldpaint")
public class WorldPaintItems {
    public static final Item COLORPICKER = new ItemColorPicker();
    public static final Item PAINTING_BOOTS = new ItemPainingBoots();
    public static final Item PAINT = new ItemPaint();
    public static final Item PAINT_SCRUBBER = new ItemPaintScrubber();
    public static final Item PAINTBRUSH = new ItemPaintBrush();
    private static final ArrayList<Item> itemList = new ArrayList();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        WorldPaintItems.registerItems((IForgeRegistry<Item>)event.getRegistry(), PAINTING_BOOTS, PAINT, COLORPICKER, PAINT_SCRUBBER, PAINTBRUSH);
    }

    private static void registerItems(IForgeRegistry<Item> registry, Item ... items) {
        itemList.addAll(Lists.newArrayList((Object[])items));
        for (Item item : items) {
            item.func_77637_a(WorldPaint.TAB);
        }
        registry.registerAll((IForgeRegistryEntry[])items);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        WorldPaintItems.registerRenderForItems(itemList.toArray(new Item[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderForItems(Item ... items) {
        for (Item item : items) {
            WorldPaintItems.registerRenderForItem(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderForItem(Item item) {
        WorldPaintItems.registerRenderForItem(item, stack -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderForItem(Item item, ItemMeshDefinition definition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)definition);
    }
}

