/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.network.packets;

import com.wynprice.modjam5.common.network.MessagePacket;
import com.wynprice.modjam5.common.utils.ByteBufHelper;
import com.wynprice.modjam5.common.utils.capability.CapabilityHandler;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class MessagePacketSyncChunk
extends MessagePacket<MessagePacketSyncChunk> {
    private Map<BlockPos, DataInfomation> map;
    private ChunkPos pos;
    private BlockPos fromPos;
    private BlockPos toPos;
    boolean refreshChunks;
    private boolean doRenderUpdate = true;

    public MessagePacketSyncChunk() {
    }

    public MessagePacketSyncChunk(Chunk chunk) {
        this(chunk, BlockPos.field_177992_a, BlockPos.field_177992_a);
        this.doRenderUpdate = false;
    }

    public MessagePacketSyncChunk(Chunk chunk, BlockPos renderPos) {
        this(chunk, renderPos, renderPos);
    }

    public MessagePacketSyncChunk(Chunk chunk, BlockPos fromPos, BlockPos toPos) {
        this.map = chunk.hasCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP) ? new HashMap<BlockPos, DataInfomation>(((CapabilityHandler.IDataInfomationProvider)chunk.getCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP)).getMap()) : new HashMap();
        this.pos = chunk.func_76632_l();
        this.fromPos = fromPos;
        this.toPos = toPos;
    }

    public MessagePacketSyncChunk setRefreshChunk(boolean refreshChunks) {
        this.refreshChunks = refreshChunks;
        return this;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        ByteBufHelper.writeCapsToBuf(buf, this.map);
        buf.writeInt(this.pos.field_77276_a);
        buf.writeInt(this.pos.field_77275_b);
        buf.writeBoolean(this.refreshChunks);
        buf.writeBoolean(this.doRenderUpdate);
        if (this.doRenderUpdate) {
            buf.writeInt(this.fromPos.func_177958_n());
            buf.writeInt(this.fromPos.func_177956_o());
            buf.writeInt(this.fromPos.func_177952_p());
            buf.writeInt(this.toPos.func_177958_n());
            buf.writeInt(this.toPos.func_177956_o());
            buf.writeInt(this.toPos.func_177952_p());
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.map = ByteBufHelper.readCapsFromBuf(buf);
        this.pos = new ChunkPos(buf.readInt(), buf.readInt());
        this.refreshChunks = buf.readBoolean();
        this.doRenderUpdate = buf.readBoolean();
        if (this.doRenderUpdate) {
            this.fromPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.toPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        }
    }

    @Override
    public void onReceived(MessagePacketSyncChunk message, EntityPlayer player) {
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(message.pos.field_77276_a, message.pos.field_77275_b);
        if (chunk.hasCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP)) {
            CapabilityHandler.IDataInfomationProvider provider = (CapabilityHandler.IDataInfomationProvider)chunk.getCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP);
            provider.getMap().clear();
            provider.getMap().putAll(message.map);
            provider.sync();
        }
        if (message.refreshChunks) {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
        if (message.doRenderUpdate) {
            player.field_70170_p.func_175704_b(message.fromPos, message.toPos);
        }
    }
}

