/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.network.packets;

import com.wynprice.modjam5.common.network.MessagePacket;
import com.wynprice.modjam5.common.utils.ColorUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Point;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public class MessagePacketColorGuiClosed
extends MessagePacket<MessagePacketColorGuiClosed> {
    private int handOrdinal;
    private int newColor;
    private Point colorPoint;
    private float lightness;

    public MessagePacketColorGuiClosed() {
    }

    public MessagePacketColorGuiClosed(EnumHand hand, int newColor, Point colorPoint, float lightness) {
        this.handOrdinal = hand.ordinal();
        this.newColor = newColor;
        this.colorPoint = colorPoint;
        this.lightness = lightness;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.handOrdinal);
        buf.writeInt(this.newColor);
        buf.writeInt(this.colorPoint.x);
        buf.writeInt(this.colorPoint.y);
        buf.writeFloat(this.lightness);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.handOrdinal = buf.readInt();
        this.newColor = buf.readInt();
        this.colorPoint = new Point(buf.readInt(), buf.readInt());
        this.lightness = buf.readFloat();
    }

    @Override
    public void onReceived(MessagePacketColorGuiClosed message, EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.values()[message.handOrdinal]);
        ColorUtils.setColor(stack, message.newColor);
        NBTTagCompound tag = stack.func_190925_c("worldpaint");
        tag.func_74768_a("pointX", message.colorPoint.x);
        tag.func_74768_a("pointY", message.colorPoint.y);
        tag.func_74776_a("lightnessValue", message.lightness);
    }
}

