/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.network;

import com.wynprice.modjam5.common.network.packets.MessagePacketColorGuiClosed;
import com.wynprice.modjam5.common.network.packets.MessagePacketRequestCapability;
import com.wynprice.modjam5.common.network.packets.MessagePacketSingleBlockUpdate;
import com.wynprice.modjam5.common.network.packets.MessagePacketSyncChunk;
import com.wynprice.modjam5.common.network.packets.MessagePacketSyncEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class WorldPaintNetwork {
    private static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("worldpaint");
    private static int idCount = -1;

    public static void preInit() {
        WorldPaintNetwork.registerMessage(MessagePacketSyncChunk.class, Side.CLIENT);
        WorldPaintNetwork.registerMessage(MessagePacketRequestCapability.class, Side.SERVER);
        WorldPaintNetwork.registerMessage(MessagePacketColorGuiClosed.class, Side.SERVER);
        WorldPaintNetwork.registerMessage(MessagePacketSyncEntity.class, Side.CLIENT);
        WorldPaintNetwork.registerMessage(MessagePacketSingleBlockUpdate.class, Side.CLIENT);
    }

    public static void registerMessage(Class claz, Side recievingSide) {
        INSTANCE.registerMessage(claz, claz, idCount++, recievingSide);
    }

    public static void sendToServer(IMessage message) {
        INSTANCE.sendToServer(message);
    }

    public static void sendToPlayer(EntityPlayer player, IMessage message) {
        if (!player.field_70170_p.field_72995_K) {
            INSTANCE.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendToPlayersInWorld(World world, IMessage message) {
        if (world == null) {
            WorldPaintNetwork.sendToAll(message);
        } else if (!world.field_72995_K) {
            INSTANCE.sendToDimension(message, world.field_73011_w.getDimension());
        }
    }

    public static void sendToAll(IMessage message) {
        INSTANCE.sendToAll(message);
    }
}

