/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.items;

import com.google.common.collect.Lists;
import com.wynprice.modjam5.common.WorldColorsHandler;
import com.wynprice.modjam5.common.network.WorldPaintNetwork;
import com.wynprice.modjam5.common.network.packets.MessagePacketSingleBlockUpdate;
import com.wynprice.modjam5.common.network.packets.MessagePacketSyncChunk;
import com.wynprice.modjam5.common.utils.BlockPosHelper;
import com.wynprice.modjam5.common.utils.capability.CapabilityHandler;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemPaintScrubber
extends Item {
    public ItemPaintScrubber() {
        this.setRegistryName("paint_scrubber");
        this.func_77655_b("paint_scrubber");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DataInfomation info = WorldColorsHandler.getInfo(worldIn, pos);
        BlockPos defaultPos = pos;
        DataInfomation defaultInfo = info;
        if (info.isDefault()) {
            for (EnumFacing dir : EnumFacing.values()) {
                DataInfomation info2 = WorldColorsHandler.getInfo(worldIn, pos.func_177972_a(dir));
                if (info2.isDefault()) continue;
                info = info2;
                pos = pos.func_177972_a(dir);
                break;
            }
        }
        CapabilityHandler.IDataInfomationProvider provider = (CapabilityHandler.IDataInfomationProvider)worldIn.func_175726_f(pos).getCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP);
        if (!info.isDefault() && provider != null) {
            if (info.isSpreadable()) {
                ArrayList chunkList = Lists.newArrayList();
                List<BlockPos> list = provider.getPositionFromOrigin(info.getOrigin());
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null) continue;
                    WorldColorsHandler.putInfo(worldIn, list.get(i), null, false);
                    Chunk chunk = worldIn.func_175726_f(list.get(i));
                    if (chunkList.contains(chunk)) continue;
                    chunkList.add(chunk);
                }
                if (!worldIn.field_72995_K) {
                    for (Chunk chunk : chunkList) {
                        if (chunkList.indexOf(chunk) == chunkList.size() - 1) {
                            Pair<BlockPos, BlockPos> positions = BlockPosHelper.getRange(list);
                            WorldPaintNetwork.sendToPlayersInWorld(worldIn, new MessagePacketSyncChunk(chunk, (BlockPos)positions.getLeft(), (BlockPos)positions.getRight()));
                            continue;
                        }
                        WorldPaintNetwork.sendToPlayersInWorld(worldIn, new MessagePacketSyncChunk(chunk));
                    }
                }
            } else if (!worldIn.field_72995_K) {
                WorldColorsHandler.putInfo(worldIn, defaultPos, null, false);
                WorldPaintNetwork.sendToPlayersInWorld(worldIn, new MessagePacketSingleBlockUpdate(defaultPos, null));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void refreshChunks() {
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }
}

