/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.entities;

import com.wynprice.modjam5.client.particles.ParticleThrownEntityPaintExplosion;
import com.wynprice.modjam5.common.WorldColorsHandler;
import com.wynprice.modjam5.common.WorldPaintConfig;
import com.wynprice.modjam5.common.utils.BlockPosHelper;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class EntityPaintThrown
extends EntityThrowable {
    private int color = 0xFFFFFF;

    public EntityPaintThrown(World worldIn) {
        super(worldIn);
    }

    public EntityPaintThrown(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityPaintThrown(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        ArrayList<BlockPos> posisionList = new ArrayList<BlockPos>();
        Random rand = new Random(id);
        this.field_70170_p.func_72960_a((Entity)this, id);
        int rad = rand.nextInt(3) + 4;
        for (int x = -rad; x < rad; ++x) {
            for (int y = -rad; y < rad; ++y) {
                for (int z = -rad; z < rad; ++z) {
                    BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                    if (!WorldPaintConfig.GENERAL.getAllowedBlocks().contains(this.field_70170_p.func_180495_p(pos).func_177230_c())) continue;
                    posisionList.add(pos);
                    WorldColorsHandler.putInfo(this.field_70170_p, pos, new DataInfomation(this.color, true, this.func_180425_c(), new int[0]), false);
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            Pair<BlockPos, BlockPos> pair = BlockPosHelper.getRange(posisionList);
            this.field_70170_p.func_175704_b((BlockPos)pair.getLeft(), (BlockPos)pair.getRight());
        }
        float speed = 5.0f;
        for (int i = 0; i < 15; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleThrownEntityPaintExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (rand.nextDouble() * 2.0 - 1.0) * (double)speed, (rand.nextDouble() * 2.0 - 1.0) * (double)speed, (rand.nextDouble() * 2.0 - 1.0) * (double)speed, this.color));
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            int id = new Random().nextInt();
            Random rand = new Random(id);
            this.field_70170_p.func_72960_a((Entity)this, (byte)id);
            int rad = rand.nextInt(WorldPaintConfig.GENERAL.maxPaintExplosion - WorldPaintConfig.GENERAL.minPaintExplosion) + WorldPaintConfig.GENERAL.minPaintExplosion;
            for (int x = -rad; x < rad; ++x) {
                for (int y = -rad; y < rad; ++y) {
                    for (int z = -rad; z < rad; ++z) {
                        BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                        if (!WorldPaintConfig.GENERAL.getAllowedBlocks().contains(this.field_70170_p.func_180495_p(pos).func_177230_c()) || !(this.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < (double)rad) && !(rand.nextFloat() < 0.3f)) continue;
                        WorldColorsHandler.putInfo(this.field_70170_p, pos, new DataInfomation(this.color, true, this.func_180425_c(), new int[0]), false);
                    }
                }
            }
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187886_fs, SoundCategory.NEUTRAL, 3.0f, (float)(rad - 2) / 5.0f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("worldPaintColor", this.color);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.color = compound.func_74762_e("worldPaintColor");
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

