/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.core;

import com.wynprice.modjam5.client.IWorldPaintColorResolver;
import com.wynprice.modjam5.common.core.WorldPaintCore;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WorldPaintTransformer
implements IClassTransformer {
    private final Consumer<ClassNode> BiomeColorHelper = node -> {
        for (MethodNode method : node.methods) {
            AbstractInsnNode ins;
            if (!method.name.equals(this.getName("getColorAtPos", "func_180285_a")) || (ins = method.instructions.get(method.instructions.size() - 2)).getOpcode() != 172) continue;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/modjam5/common/core/WorldPaintHooksClient", "getProperBiomeColor", "(ILnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lcom/wynprice/modjam5/client/IWorldPaintColorResolver;)I", false));
            method.instructions.insertBefore(ins, list);
        }
    };
    private final Consumer<ClassNode> WorldServer = node -> {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(this.getName("updateBlocks", "func_147456_g"))) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode ins = method.instructions.get(i);
                if (ins.getOpcode() != 18 || !(ins instanceof LdcInsnNode)) continue;
                LdcInsnNode lIns = (LdcInsnNode)ins;
                if (!lIns.cst.equals("randomTick")) continue;
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 18));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/util/math/BlockPos"));
                list.add((AbstractInsnNode)new InsnNode(89));
                list.add((AbstractInsnNode)new VarInsnNode(21, 14));
                list.add((AbstractInsnNode)new VarInsnNode(21, 6));
                list.add((AbstractInsnNode)new InsnNode(96));
                list.add((AbstractInsnNode)new VarInsnNode(21, 16));
                list.add((AbstractInsnNode)new VarInsnNode(25, 11));
                list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/chunk/storage/ExtendedBlockStorage", this.getName("getYLocation", "func_76662_d"), "()I", false));
                list.add((AbstractInsnNode)new InsnNode(96));
                list.add((AbstractInsnNode)new VarInsnNode(21, 15));
                list.add((AbstractInsnNode)new VarInsnNode(21, 7));
                list.add((AbstractInsnNode)new InsnNode(96));
                list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/util/math/BlockPos", "<init>", "(III)V", false));
                list.add((AbstractInsnNode)new VarInsnNode(25, 17));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/WorldServer", this.getName("rand", "field_73012_v"), "Ljava/util/Random;"));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/modjam5/common/core/WorldPaintHooks", "onRandomTick", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Ljava/util/Random;)V", false));
                method.instructions.insert(method.instructions.get(i + 1), list);
            }
        }
    };
    private final Consumer<ClassNode> Block = node -> {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getSlipperiness") || !method.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)F")) continue;
            AbstractInsnNode startLabel = method.instructions.getFirst();
            AbstractInsnNode lineNumberLabel = method.instructions.get(1);
            AbstractInsnNode endLabel = method.instructions.getLast();
            InsnList list = new InsnList();
            list.add(startLabel);
            list.add(lineNumberLabel);
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 4));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/block/Block", this.getName("slipperiness", "field_149765_K"), "F"));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/modjam5/common/core/WorldPaintHooks", "getBlockSlipperiness", "(Lnet/minecraft/block/Block;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)F", false));
            list.add((AbstractInsnNode)new InsnNode(174));
            list.add(endLabel);
            method.instructions = list;
        }
    };
    private final Consumer<ClassNode> Entity = node -> {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(this.getName("move", "func_70091_d")) || !method.desc.equals("(Lnet/minecraft/entity/MoverType;DDD)V")) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode ins = method.instructions.get(i);
                if (!(ins instanceof MethodInsnNode) || ins.getOpcode() != 182) continue;
                MethodInsnNode mIns = (MethodInsnNode)ins;
                if (!mIns.owner.equals("net/minecraft/block/Block") || !mIns.name.equals(this.getName("onLanded", "func_176216_a")) || !mIns.desc.equals("(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)V")) continue;
                method.instructions.set(ins, (AbstractInsnNode)new MethodInsnNode(184, "com/wynprice/modjam5/common/core/WorldPaintHooks", "onLanded", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)V", false));
            }
        }
    };

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.world.biome.BiomeColorHelper")) {
            basicClass = this.runConsumer(this.BiomeColorHelper, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.world.biome.BiomeColorHelper$ColorResolver")) {
            basicClass = this.runConsumer(node -> node.interfaces.add(Type.getInternalName(IWorldPaintColorResolver.class)), transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.world.WorldServer")) {
            basicClass = this.runConsumer(this.WorldServer, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.block.Block")) {
            basicClass = this.runConsumer(this.Block, transformedName, basicClass);
        } else if (transformedName.equals("net.minecraft.entity.Entity")) {
            basicClass = this.runConsumer(this.Entity, transformedName, basicClass);
        }
        return basicClass;
    }

    private byte[] runConsumer(Consumer<ClassNode> cons, String transformedName, byte[] basicClass) {
        FMLLog.info((String)("[WorldPaintTransformer] Running Transform on " + transformedName), (Object[])new Object[0]);
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(basicClass);
        reader.accept((ClassVisitor)node, 0);
        cons.accept(node);
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private String getName(String workspaceName, String mcpName) {
        return WorldPaintCore.isDebofEnabled ? mcpName : workspaceName;
    }
}

