/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.core;

import com.google.common.collect.Lists;
import com.wynprice.modjam5.common.WorldColorsHandler;
import com.wynprice.modjam5.common.WorldPaintConfig;
import com.wynprice.modjam5.common.colorfunctionality.ColorBehaviourEventDispatcher;
import com.wynprice.modjam5.common.colorfunctionality.ColorFunctions;
import com.wynprice.modjam5.common.utils.ColorUtils;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldPaintHooks {
    public static void onRandomTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (new Random().nextFloat() < WorldPaintConfig.GENERAL.spreadChance || !WorldPaintConfig.GENERAL.getAllowedBlocks().contains(block)) {
            return;
        }
        if (!worldIn.field_72995_K) {
            DataInfomation info = WorldColorsHandler.getInfo(worldIn, pos);
            ColorBehaviourEventDispatcher.onRandomBlockTick(worldIn, pos, info);
            if (info.isSpreadable()) {
                DataInfomation dirInfo;
                if (info.getSpreadTo().length >= EnumFacing.values().length) {
                    return;
                }
                ArrayList<EnumFacing> facing = new ArrayList<EnumFacing>();
                for (EnumFacing face : EnumFacing.values()) {
                    if (Lists.newArrayList((Object[])new int[][]{info.getSpreadTo()}).contains(face.func_176745_a())) continue;
                    facing.add(face);
                }
                EnumFacing dir = (EnumFacing)facing.get(rand.nextInt(facing.size()));
                info.addFace(dir);
                if (dir.func_176740_k() == EnumFacing.Axis.Y) {
                    pos = pos.func_177972_a(dir);
                    dir = EnumFacing.func_176731_b((int)rand.nextInt());
                }
                if ((dirInfo = WorldColorsHandler.getInfo(worldIn, pos.func_177972_a(dir))).isDefault()) {
                    WorldColorsHandler.putInfo(worldIn, pos.func_177972_a(dir), info, true);
                }
            }
        }
    }

    public static float getBlockSlipperiness(Block block, IBlockState state, IBlockAccess world, BlockPos pos, Entity entity, float deafault) {
        DataInfomation info;
        if (world instanceof World && !(info = WorldColorsHandler.getInfo((World)world, pos)).isDefault() && WorldPaintConfig.GENERAL.getAllowedBlocks().contains(block) && ColorUtils.calculateClosestColor(info.getColor()) == ColorFunctions.ORANGE && WorldPaintConfig.COLOR_FUNCTIONS.orangeSlippyBlocks) {
            return entity instanceof EntityItem ? 1.0f : 1.05f;
        }
        return deafault;
    }

    public static void onLanded(Block block, World worldIn, Entity entityIn) {
        BlockPos position = entityIn.func_180425_c();
        DataInfomation info = WorldColorsHandler.getInfo(worldIn, position);
        for (int i = 0; i < 3; ++i) {
            if (!info.isDefault() && worldIn.func_180495_p(position).func_185904_a() != Material.field_151579_a) continue;
            position = position.func_177977_b();
            info = WorldColorsHandler.getInfo(worldIn, position);
        }
        if (ColorUtils.calculateClosestColor(info.getColor()) == ColorFunctions.BLUE && !entityIn.func_70093_af() && WorldPaintConfig.COLOR_FUNCTIONS.blueBouncyBlocks) {
            entityIn.field_70181_x = -entityIn.field_70181_x * (double)0.9f;
            return;
        }
        block.func_176216_a(worldIn, entityIn);
    }
}

