/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.colorfunctionality.colors;

import com.wynprice.modjam5.common.WorldColorsHandler;
import com.wynprice.modjam5.common.WorldPaintConfig;
import com.wynprice.modjam5.common.colorfunctionality.ColorFunction;
import com.wynprice.modjam5.common.utils.ColorUtils;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class ColorGray
extends ColorFunction {
    public ColorGray() {
        super("gray", 0.0, 0.0, ColorFunction.RangeType.HUE);
    }

    @Override
    public void onWorldTick(World world) {
        List entityMap = world.field_147482_g;
        int size = world.field_175730_i.size();
        for (int i = 0; i < size; ++i) {
            ColorFunction function;
            TileEntity entry;
            DataInfomation info;
            if (world.field_175730_i.size() <= i || (info = WorldColorsHandler.getInfo(world, (entry = (TileEntity)world.field_175730_i.get(i)).func_174877_v().func_177977_b())).isDefault() || (function = ColorUtils.calculateClosestColor(info.getColor())) != this || !(entry instanceof TileEntityFurnace)) continue;
            Random random = new Random();
            if (!(random.nextFloat() < WorldPaintConfig.COLOR_FUNCTIONS.grayFurnaceSmelt)) continue;
            for (int i2 = 0; i2 < WorldPaintConfig.COLOR_FUNCTIONS.grayFurnaceAmount; ++i2) {
                ((TileEntityFurnace)entry).func_73660_a();
            }
        }
    }

    private boolean canSmelt(TileEntityFurnace te) {
        if (te.func_70301_a(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(te.func_70301_a(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = te.func_70301_a(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= te.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    @Override
    public boolean shouldApply(float[] hsb) {
        Color color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return (double)Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue())) > WorldPaintConfig.COLOR_VALUES.grayMin && (double)Math.min(color.getRed(), Math.min(color.getGreen(), color.getBlue())) < WorldPaintConfig.COLOR_VALUES.grayMax && (double)((float)(Math.abs(color.getRed() - color.getGreen()) + Math.abs(color.getGreen() - color.getBlue())) / 2.0f) < WorldPaintConfig.COLOR_VALUES.grayRange;
    }
}

