/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common.colorfunctionality;

import com.wynprice.modjam5.common.WorldColorsHandler;
import com.wynprice.modjam5.common.WorldPaintConfig;
import com.wynprice.modjam5.common.colorfunctionality.ColorFunction;
import com.wynprice.modjam5.common.colorfunctionality.ColorFunctions;
import com.wynprice.modjam5.common.utils.ColorUtils;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="worldpaint")
public class ColorBehaviourEventDispatcher {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        BlockPos position = event.getEntity().func_180425_c();
        DataInfomation info = WorldColorsHandler.getInfo(event.getEntity().field_70170_p, position);
        for (int i = 0; i < 3; ++i) {
            if (!info.isDefault() && event.getEntity().field_70170_p.func_180495_p(position).func_185904_a() != Material.field_151579_a) continue;
            position = position.func_177977_b();
            info = WorldColorsHandler.getInfo(event.getEntity().field_70170_p, position);
        }
        ColorFunction inFunction = null;
        if (WorldPaintConfig.GENERAL.getAllowedBlocks().contains(event.getEntity().field_70170_p.func_180495_p(position).func_177230_c()) && !info.isDefault()) {
            inFunction = ColorUtils.calculateClosestColor(info.getColor());
            inFunction.onMobTick(event.getEntityLiving());
        }
        for (ColorFunction function : ColorFunctions.AWAY_FUNCTIONS) {
            if (function == inFunction) continue;
            function.onAwayMobTick(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingDamageEvent event) {
        BlockPos position = event.getEntity().func_180425_c();
        DataInfomation info = WorldColorsHandler.getInfo(event.getEntity().field_70170_p, position);
        for (int i = 0; i < 10; ++i) {
            if (!info.isDefault() && event.getEntity().field_70170_p.func_180495_p(position).func_185904_a() != Material.field_151579_a) continue;
            position = position.func_177977_b();
            info = WorldColorsHandler.getInfo(event.getEntity().field_70170_p, position);
        }
        ColorFunction inFunction = null;
        if (WorldPaintConfig.GENERAL.getAllowedBlocks().contains(event.getEntity().field_70170_p.func_180495_p(position).func_177230_c()) && !info.isDefault()) {
            inFunction = ColorUtils.calculateClosestColor(info.getColor());
            event.setCanceled(inFunction.onEntityDamaged(event.getEntityLiving(), event.getSource(), event.getAmount()));
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        for (ColorFunction function : ColorFunctions.ALL_FUNCTIONS) {
            function.onWorldTick(event.world);
        }
    }

    public static void onRandomBlockTick(World world, BlockPos pos, DataInfomation info) {
        if (!info.isDefault()) {
            ColorUtils.calculateClosestColor(info.getColor()).onBlockTick(world, pos);
        }
    }
}

