/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.common;

import com.wynprice.modjam5.common.network.WorldPaintNetwork;
import com.wynprice.modjam5.common.network.packets.MessagePacketRequestCapability;
import com.wynprice.modjam5.common.network.packets.MessagePacketSyncChunk;
import com.wynprice.modjam5.common.utils.BlockPosHelper;
import com.wynprice.modjam5.common.utils.capability.CapabilityHandler;
import com.wynprice.modjam5.common.utils.capability.DataInfomation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="worldpaint")
public class WorldColorsHandler {
    private static final ArrayList<ChunkPos> requestedChunks = new ArrayList();
    public static HashMap<ChunkPos, Pair<Long, ArrayList<BlockPos>>> syncedChunks = new HashMap();

    @SubscribeEvent
    public static void chunkRegistry(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("worldpaint", "colorProvider"), (ICapabilityProvider)new CapabilityHandler.ColorCapabilityProvider());
    }

    public static DataInfomation getInfo(World worldIn, BlockPos pos) {
        CapabilityHandler.IDataInfomationProvider cap;
        if (worldIn == null) {
            return DataInfomation.DEFAULT;
        }
        Chunk chunk = worldIn.func_175726_f(pos);
        CapabilityHandler.IDataInfomationProvider iDataInfomationProvider = cap = chunk.hasCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP) ? (CapabilityHandler.IDataInfomationProvider)chunk.getCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP) : null;
        if (cap != null) {
            DataInfomation info;
            if (worldIn.field_72995_K) {
                if (!cap.hasSynced() && !requestedChunks.contains(chunk.func_76632_l())) {
                    requestedChunks.add(chunk.func_76632_l());
                    WorldPaintNetwork.sendToServer(new MessagePacketRequestCapability(chunk));
                }
                if (cap.hasSynced() && requestedChunks.contains(chunk.func_76632_l())) {
                    requestedChunks.remove(chunk.func_76632_l());
                }
            }
            return (info = cap.getMap().get(pos)) == null ? DataInfomation.DEFAULT : info;
        }
        return DataInfomation.DEFAULT;
    }

    public static void putInfo(World worldIn, BlockPos pos, DataInfomation info, boolean doRenderUpdate) {
        CapabilityHandler.IDataInfomationProvider cap;
        Chunk chunk = worldIn.func_175726_f(pos);
        CapabilityHandler.IDataInfomationProvider iDataInfomationProvider = cap = chunk.hasCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP) ? (CapabilityHandler.IDataInfomationProvider)chunk.getCapability(CapabilityHandler.DATA_CAPABILITY, EnumFacing.UP) : null;
        if (cap != null) {
            if (info == null) {
                cap.getMap().remove(pos);
            } else {
                cap.getMap().put(pos, info);
                cap.addPositionToOriginList(info.getOrigin(), pos);
            }
            if (doRenderUpdate && !worldIn.field_72995_K) {
                if (!syncedChunks.containsKey(chunk.func_76632_l())) {
                    syncedChunks.put(chunk.func_76632_l(), (Pair<Long, ArrayList<BlockPos>>)Pair.of((Object)worldIn.func_82737_E(), new ArrayList()));
                }
                ((ArrayList)syncedChunks.get(chunk.func_76632_l()).getRight()).add(pos);
                if (worldIn.func_82737_E() - (Long)syncedChunks.get(chunk.func_76632_l()).getLeft() > 20L) {
                    Pair<BlockPos, BlockPos> positions = BlockPosHelper.getRange((List)syncedChunks.get(chunk.func_76632_l()).getRight());
                    syncedChunks.put(chunk.func_76632_l(), (Pair<Long, ArrayList<BlockPos>>)Pair.of((Object)worldIn.func_82737_E(), new ArrayList()));
                    WorldPaintNetwork.sendToAll(new MessagePacketSyncChunk(chunk, (BlockPos)positions.getLeft(), (BlockPos)positions.getRight()));
                }
            }
        }
    }
}

