/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.modjam5.client.gui;

import com.wynprice.modjam5.common.network.WorldPaintNetwork;
import com.wynprice.modjam5.common.network.packets.MessagePacketColorGuiClosed;
import com.wynprice.modjam5.common.registries.WorldPaintItems;
import com.wynprice.modjam5.common.utils.ColorUtils;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;

public class GuiColorWheel
extends GuiScreen {
    private Point currentColorWheel = new Point(-1, -1);
    private int prevColor = Color.WHITE.getRGB();
    private int noBrightnessColor = -1;
    private final ItemStack stack;
    private final EnumHand hand;
    private boolean lightnessBarClicked = false;
    private float barAmount = 1.0f;

    public GuiColorWheel(EnumHand hand, ItemStack stack) {
        this.stack = stack;
        this.hand = hand;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        NBTTagCompound tag = this.stack.func_190925_c("worldpaint");
        if (tag.func_150297_b("pointX", 99) && tag.func_150297_b("pointY", 99)) {
            this.currentColorWheel = new Point(Minecraft.func_71410_x().field_71443_c / 2 + tag.func_74762_e("pointX"), Minecraft.func_71410_x().field_71440_d / 2 + tag.func_74762_e("pointY"));
            this.prevColor = ColorUtils.getColor(this.stack);
            this.barAmount = tag.func_74760_g("lightnessValue");
        } else {
            this.currentColorWheel = new Point(Minecraft.func_71410_x().field_71443_c / 2, Minecraft.func_71410_x().field_71440_d / 2);
            this.barAmount = 1.0f;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        int colorPre = GuiColorWheel.getColorUnderMouse();
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(new ResourceLocation("worldpaint", "textures/gui/widgits/color_wheel.png"));
        GuiColorWheel.func_146110_a((int)(this.field_146294_l / 2 - 64), (int)(this.field_146295_m / 2 - 64), (float)0.0f, (float)0.0f, (int)128, (int)128, (float)128.0f, (float)128.0f);
        int newColor = GuiColorWheel.getColorUnderMouse();
        if (colorPre != newColor && Mouse.isButtonDown((int)0) && !this.lightnessBarClicked) {
            this.currentColorWheel = new Point(Mouse.getX(), Mouse.getY());
            this.prevColor = newColor;
            this.noBrightnessColor = newColor;
        }
        if (this.lightnessBarClicked || this.noBrightnessColor == -1) {
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)1);
            int[] ints = new int[1];
            GlStateManager.func_187413_a((int)this.currentColorWheel.x, (int)this.currentColorWheel.y, (int)1, (int)1, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(ints);
            this.prevColor = ints[0];
            if (this.noBrightnessColor == -1) {
                this.noBrightnessColor = this.prevColor;
            }
        }
        float[] hsbs = Color.RGBtoHSB(this.prevColor >> 16 & 0xFF, this.prevColor >> 8 & 0xFF, this.prevColor & 0xFF, null);
        this.prevColor = Color.HSBtoRGB(hsbs[0], hsbs[1], this.barAmount);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(new ResourceLocation("worldpaint", "textures/gui/widgits/color_wheel_border.png"));
        GuiColorWheel.func_146110_a((int)(this.field_146294_l / 2 - 65), (int)(this.field_146295_m / 2 - 65), (float)0.0f, (float)0.0f, (int)130, (int)130, (float)130.0f, (float)130.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(new ResourceLocation("worldpaint", "textures/gui/widgits/color_wheel_cursor.png"));
        GuiColorWheel.func_146110_a((int)(this.currentColorWheel.x * new ScaledResolution(this.field_146297_k).func_78326_a() / this.field_146297_k.field_71443_c - 4), (int)(new ScaledResolution(this.field_146297_k).func_78328_b() - this.currentColorWheel.y * new ScaledResolution(this.field_146297_k).func_78328_b() / this.field_146297_k.field_71440_d - 1 - 4), (float)0.0f, (float)0.0f, (int)8, (int)8, (float)8.0f, (float)8.0f);
        this.drawHorizontalGradient(this.field_146294_l / 2 + 70, this.field_146295_m / 5 * 4 + 20, this.field_146294_l / 2 - 70, this.field_146295_m / 5 * 4, -16777216, this.noBrightnessColor);
        int xPosition = (int)((float)(this.field_146294_l / 2 + 70) - (1.0f - this.barAmount) * 140.0f);
        GuiColorWheel.func_73734_a((int)(xPosition - 3), (int)(this.field_146295_m / 5 * 4 - 3), (int)(xPosition + 3), (int)(this.field_146295_m / 5 * 4 + 23), (int)-16777216);
        this.drawBorder(this.field_146294_l / 2 + 70, this.field_146295_m / 5 * 4 + 20, this.field_146294_l / 2 - 70, this.field_146295_m / 5 * 4, -16777216, 2);
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)5.0f);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(ColorUtils.setColor(new ItemStack(WorldPaintItems.COLORPICKER), this.prevColor), this.field_146294_l / 80 * 3 - 8, this.field_146295_m / 10 - 8);
        GlStateManager.func_179152_a((float)-5.0f, (float)-5.0f, (float)-5.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseX >= this.field_146294_l / 2 - 70 && mouseX <= this.field_146294_l / 2 + 70 && mouseY >= this.field_146295_m / 5 * 4 && mouseY <= this.field_146295_m / 5 * 4 + 20) {
            this.lightnessBarClicked = true;
            this.barAmount = (float)(mouseX - this.field_146294_l / 2 + 70) / 140.0f;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.lightnessBarClicked = false;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.lightnessBarClicked) {
            this.barAmount = MathHelper.func_76131_a((float)((float)(mouseX - this.field_146294_l / 2 + 70) / 140.0f), (float)0.0f, (float)1.0f);
        }
    }

    public void func_146281_b() {
        WorldPaintNetwork.sendToServer(new MessagePacketColorGuiClosed(this.hand, this.prevColor, new Point(this.currentColorWheel.x - Minecraft.func_71410_x().field_71443_c / 2, this.currentColorWheel.y - Minecraft.func_71410_x().field_71440_d / 2), this.barAmount));
        super.func_146281_b();
    }

    public static int getColorUnderMouse() {
        IntBuffer intbuffer = BufferUtils.createIntBuffer((int)1);
        int[] ints = new int[1];
        GlStateManager.func_187413_a((int)Mouse.getX(), (int)Mouse.getY(), (int)1, (int)1, (int)32993, (int)33639, (IntBuffer)intbuffer);
        intbuffer.get(ints);
        return ints[0];
    }

    public void drawHorizontalGradient(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)this.field_73735_i).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)this.field_73735_i).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)this.field_73735_i).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)this.field_73735_i).func_181666_a(f1, f2, f3, f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void drawBorder(int left, int top, int right, int bottom, int color, int thickness) {
        GuiScreen.func_73734_a((int)(left - (thickness /= 2)), (int)(top - thickness), (int)(right + thickness), (int)(top + thickness), (int)color);
        GuiScreen.func_73734_a((int)(left - thickness), (int)(bottom - thickness), (int)(right + thickness), (int)(bottom + thickness), (int)color);
        GuiScreen.func_73734_a((int)(left - thickness), (int)(top + thickness), (int)(left + thickness), (int)(bottom - thickness), (int)color);
        GuiScreen.func_73734_a((int)(right + thickness), (int)(top + thickness), (int)(right - thickness), (int)(bottom - thickness), (int)color);
    }
}

