/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.sdrones.networking;

import com.suppergerrie2.sdrones.entities.EntityBasicDrone;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ItemsInDroneMessage
implements IMessage {
    private ItemStack[] toSend;
    private int id;
    private ItemStack[] received;

    public ItemsInDroneMessage() {
    }

    public ItemsInDroneMessage(ItemStack[] toSend, int id) {
        this.toSend = toSend;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        int size = buf.readInt();
        ItemStack[] stacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            stacks[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.received = stacks;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.toSend.length);
        for (ItemStack stack : this.toSend) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public static class ItemsInDroneMessageHandler
    implements IMessageHandler<ItemsInDroneMessage, IMessage> {
        public IMessage onMessage(ItemsInDroneMessage message, MessageContext ctx) {
            int id = message.id;
            ItemStack[] stacks = message.received;
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityBasicDrone drone = (EntityBasicDrone)Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
                if (drone != null) {
                    drone.setItemStacksInDrone(stacks);
                }
            });
            return null;
        }
    }
}

