/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.sdrones.entities;

import com.suppergerrie2.sdrones.entities.AI.EntityAIGoHome;
import com.suppergerrie2.sdrones.entities.AI.treefarm.EntityAICutTree;
import com.suppergerrie2.sdrones.entities.AI.treefarm.EntityAIPlantSapling;
import com.suppergerrie2.sdrones.entities.EntityBasicDrone;
import com.suppergerrie2.sdrones.networking.DronesPacketHandler;
import com.suppergerrie2.sdrones.networking.ItemsInDroneMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class EntityTreeFarmDrone
extends EntityBasicDrone {
    public EntityTreeFarmDrone(World worldIn, double x, double y, double z, ItemStack spawnedWith, EnumFacing facing, int carrySize) {
        super(worldIn, x, y, z, spawnedWith, facing, carrySize);
    }

    public EntityTreeFarmDrone(World worldIn, double x, double y, double z, ItemStack spawnedWith, EnumFacing facing) {
        this(worldIn, x, y, z, spawnedWith, facing, 1);
    }

    public EntityTreeFarmDrone(World worldIn) {
        this(worldIn, -1.0, -1.0, -1.0, ItemStack.field_190927_a, EnumFacing.UP);
    }

    @Override
    void setupAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPlantSapling(this, 1.0, 16));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICutTree(this, 1.0, 16));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGoHome(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
    }

    public ItemStack getWeapon() {
        return new ItemStack(Items.field_151056_x);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.hasSapling() && this.func_174818_b(this.func_180486_cf()) < 4.0) {
                this.tryGetSapling(this.func_180486_cf());
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    if (!(this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(x, 0, y)).func_177230_c() instanceof BlockLeaves)) continue;
                    this.field_70170_p.func_175655_b(this.func_180425_c().func_177982_a(x, 0, y), true);
                }
            }
        }
    }

    boolean hasSapling() {
        for (ItemStack stack : this.itemStacksInDrone) {
            if (stack == null || stack.func_190926_b() || !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockSapling)) continue;
            return true;
        }
        return false;
    }

    public boolean tryGetSapling(BlockPos pos) {
        ItemStack pickedUp;
        IItemHandler itemHandler;
        if (!this.canPickupItem()) {
            return false;
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        if (iblockstate.func_177230_c() instanceof BlockContainer) {
            Pair destinationResult = VanillaInventoryCodeHooks.getItemHandler((World)this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (EnumFacing)EnumFacing.DOWN);
            if (destinationResult == null) {
                return false;
            }
            itemHandler = (IItemHandler)destinationResult.getKey();
            pickedUp = this.tryGetSaplingFromInventory(itemHandler);
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                if (this.itemStacksInDrone[i] == null || this.itemStacksInDrone[i].func_190926_b()) {
                    this.itemStacksInDrone[i] = pickedUp;
                    DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
                    return true;
                }
                if (this.itemStacksInDrone[i] == null || !this.couldFitItem(pickedUp, this.itemStacksInDrone[i])) continue;
                int count = this.itemStacksInDrone[i].func_190916_E();
                if ((count += pickedUp.func_190916_E()) <= this.itemStacksInDrone[i].func_77976_d()) continue;
                pickedUp.func_190920_e(count - this.itemStacksInDrone[i].func_77976_d());
            }
        } else {
            return false;
        }
        ItemStack rest = this.tryPutInInventory(pickedUp, itemHandler);
        EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, rest);
        this.field_70170_p.func_72838_d((Entity)item);
        return false;
    }

    boolean couldFitItem(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && b.func_77976_d() > b.func_190916_E();
    }

    private ItemStack tryGetSaplingFromInventory(IItemHandler dest) {
        ItemStack result = ItemStack.field_190927_a;
        for (int slot = 0; slot < dest.getSlots() && result.func_190926_b(); ++slot) {
            if (!(Block.func_149634_a((Item)dest.extractItem(slot, 1, true).func_77973_b()) instanceof BlockSapling)) continue;
            result = dest.extractItem(slot, dest.getSlotLimit(slot), false);
        }
        return result;
    }

    public ItemStack getSapling() {
        for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
            if (this.itemStacksInDrone[i].func_190926_b() || !(Block.func_149634_a((Item)this.itemStacksInDrone[i].func_77973_b()) instanceof BlockSapling)) continue;
            return this.itemStacksInDrone[i];
        }
        return ItemStack.field_190927_a;
    }

    public void useSapling() {
        for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
            if (this.itemStacksInDrone[i].func_190926_b() || !(Block.func_149634_a((Item)this.itemStacksInDrone[i].func_77973_b()) instanceof BlockSapling)) continue;
            this.itemStacksInDrone[i].func_190918_g(1);
        }
        DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
    }

    public boolean placeSapling(BlockPos destination) {
        ItemStack sapling = this.getSapling();
        if (sapling.func_190926_b()) {
            return false;
        }
        Block blockToPlace = Block.func_149634_a((Item)sapling.func_77973_b());
        IBlockState blockstate = blockToPlace.getStateForPlacement(this.field_70170_p, destination, EnumFacing.DOWN, 8.0f, 8.0f, 8.0f, sapling.func_77960_j(), (EntityLivingBase)this, EnumHand.MAIN_HAND);
        this.field_70170_p.func_175656_a(destination, blockstate);
        this.useSapling();
        return true;
    }

    public void cutTree(BlockPos destination) {
        ArrayList<BlockPos> treePositions = new ArrayList<BlockPos>();
        treePositions.add(destination);
        while (this.walkTree(treePositions)) {
        }
        for (BlockPos pos : treePositions) {
            this.field_70170_p.func_175655_b(pos, true);
        }
    }

    public boolean walkTree(List<BlockPos> positions) {
        boolean modified = false;
        ArrayList<BlockPos> copy = new ArrayList<BlockPos>(positions);
        for (BlockPos pos : copy) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 1; ++y) {
                        BlockPos pos2 = pos.func_177982_a(x, y, z);
                        if (positions.contains(pos2) || !this.field_70170_p.func_180495_p(pos2).func_177230_c().isWood((IBlockAccess)this.field_70170_p, pos2)) continue;
                        positions.add(pos2);
                        modified = true;
                    }
                }
            }
        }
        return modified;
    }
}

