/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.sdrones.entities;

import com.suppergerrie2.sdrones.init.ModSoundEvents;
import com.suppergerrie2.sdrones.items.ItemDroneStick;
import com.suppergerrie2.sdrones.networking.DronesPacketHandler;
import com.suppergerrie2.sdrones.networking.ItemsInDroneMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EntityBasicDrone
extends EntityCreature {
    ItemStack[] itemStacksInDrone;
    ItemStack spawnedWith;
    int carrySize;
    EnumFacing homeFacing;
    boolean selected = false;

    public EntityBasicDrone(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.3f);
        this.setupAI();
        this.itemStacksInDrone = new ItemStack[1];
        for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
            this.itemStacksInDrone[i] = ItemStack.field_190927_a;
        }
        this.carrySize = 1;
        this.spawnedWith = ItemStack.field_190927_a;
        this.func_110163_bv();
        this.homeFacing = EnumFacing.UP;
    }

    public EntityBasicDrone(World worldIn, double x, double y, double z, ItemStack spawnedWith, EnumFacing facing) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.func_175449_a(new BlockPos(x, y, z), 64);
        this.spawnedWith = spawnedWith;
        this.homeFacing = facing;
    }

    public EntityBasicDrone(World worldIn, double x, double y, double z, ItemStack spawnedWith, EnumFacing facing, int carrySize) {
        this(worldIn, x, y, z, spawnedWith, facing);
        if (carrySize > 0) {
            this.itemStacksInDrone = new ItemStack[carrySize];
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                this.itemStacksInDrone[i] = ItemStack.field_190927_a;
            }
            this.carrySize = carrySize;
        }
    }

    abstract void setupAI();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(160.0);
    }

    public void setHomeFacing(EnumFacing facing) {
        this.homeFacing = facing;
    }

    public boolean canPickupItem() {
        for (ItemStack stack : this.itemStacksInDrone) {
            if (stack != null && !stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean pickupItem(EntityItem item) {
        if (!item.func_174874_s() && this.canPickupItem()) {
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                ItemStack stack;
                if (this.itemStacksInDrone[i] != null && !this.itemStacksInDrone[i].func_190926_b()) continue;
                this.itemStacksInDrone[i] = stack = item.func_92059_d().func_77979_a(1);
                DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
                return true;
            }
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.itemStacksInDrone) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (itemstack != null && !itemstack.func_190926_b()) {
                itemstack.func_77955_b(nbttagcompound);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ItemsInDrone", (NBTBase)nbttaglist);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.spawnedWith.func_77955_b(nbttagcompound);
        compound.func_74782_a("SpawnedWith", (NBTBase)nbttagcompound);
        compound.func_74768_a("CarrySize", this.carrySize);
        BlockPos pos = this.func_180486_cf();
        compound.func_74783_a("HomePos", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("CarrySize")) {
            this.carrySize = compound.func_74762_e("CarrySize");
            this.itemStacksInDrone = new ItemStack[this.carrySize];
        }
        if (compound.func_150297_b("ItemsInDrone", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ItemsInDrone", 10);
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                this.itemStacksInDrone[i] = new ItemStack(nbttaglist.func_150305_b(i));
            }
        }
        if (compound.func_74764_b("SpawnedWith")) {
            this.spawnedWith = new ItemStack(compound.func_74775_l("SpawnedWith"));
        }
        if (compound.func_74764_b("HomePos")) {
            int[] homePosCoords = compound.func_74759_k("HomePos");
            this.func_175449_a(new BlockPos(homePosCoords[0], homePosCoords[1], homePosCoords[2]), 64);
        }
        DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
    }

    public boolean hasItems() {
        for (ItemStack stack : this.itemStacksInDrone) {
            if (stack == null || stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_184195_f(this.selected);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 100 == 0) {
            DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player.func_184586_b(hand).func_77973_b() instanceof ItemDroneStick) {
            if (player.func_70093_af()) {
                this.func_70106_y();
                this.func_70645_a(DamageSource.func_76365_a((EntityPlayer)player));
            } else {
                ItemDroneStick droneStick = (ItemDroneStick)player.func_184586_b(hand).func_77973_b();
                droneStick.addSelected(this);
                this.selected = true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        for (ItemStack stack : this.itemStacksInDrone) {
            if (stack == null) continue;
            this.func_70099_a(stack, 0.1f);
        }
        this.func_70099_a(this.spawnedWith, 0.1f);
    }

    public boolean insertItems(BlockPos pos) {
        IBlockState iblockstate;
        if (this.field_70170_p.func_175623_d(pos)) {
            pos = pos.func_177972_a(this.homeFacing.func_176734_d());
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(pos)).func_177230_c() instanceof BlockContainer) {
            Pair destinationResult = VanillaInventoryCodeHooks.getItemHandler((World)this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (EnumFacing)EnumFacing.UP);
            if (destinationResult == null) {
                return false;
            }
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                if (EntityBasicDrone.isItemHandlerFull(itemHandler) || this.itemStacksInDrone[i] == null || this.itemStacksInDrone[i].func_190926_b()) continue;
                this.itemStacksInDrone[i] = this.tryPutInInventory(this.itemStacksInDrone[i], itemHandler);
            }
        } else {
            return false;
        }
        DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
        return true;
    }

    public boolean tryGetItem(Class<? extends Item> itemType, BlockPos pos) {
        if (!this.canPickupItem()) {
            return false;
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
        if (iblockstate.func_177230_c() instanceof BlockContainer) {
            Pair destinationResult = VanillaInventoryCodeHooks.getItemHandler((World)this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (EnumFacing)EnumFacing.DOWN);
            if (destinationResult == null) {
                return false;
            }
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            ItemStack pickedUp = this.tryGetFromInventory(itemType, itemHandler);
            for (int i = 0; i < this.itemStacksInDrone.length; ++i) {
                if (this.itemStacksInDrone[i] != null && !this.itemStacksInDrone[i].func_190926_b()) continue;
                this.itemStacksInDrone[i] = pickedUp;
                DronesPacketHandler.INSTANCE.sendToAll((IMessage)new ItemsInDroneMessage(this.itemStacksInDrone, this.func_145782_y()));
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public ItemStack[] getItemStacksInDrone() {
        return this.itemStacksInDrone;
    }

    private static boolean isItemHandlerFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_190916_E() == stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    protected ItemStack tryPutInInventory(ItemStack stack, IItemHandler dest) {
        for (int slot = 0; slot < dest.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = dest.insertItem(slot, stack, false);
        }
        return stack;
    }

    private ItemStack tryGetFromInventory(Class<? extends Item> itemType, IItemHandler dest) {
        ItemStack result = ItemStack.field_190927_a;
        for (int slot = 0; slot < dest.getSlots() && result.func_190926_b(); ++slot) {
            if (!dest.extractItem(slot, 1, true).func_77973_b().getClass().isInstance(itemType)) continue;
            result = dest.extractItem(slot, 1, false);
        }
        return result;
    }

    public void setItemStacksInDrone(ItemStack[] stacks) {
        this.itemStacksInDrone = stacks;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.func_184195_f(b);
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.droneBleepSound;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(ModSoundEvents.droneDrivingSound, 0.15f, 1.0f);
    }

    public void func_70642_aH() {
        if (this.field_70146_Z.nextInt(5) > 1) {
            return;
        }
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }
}

