/*
 * Decompiled with CFR 0.152.
 */
package com.suppergerrie2.sdrones;

import com.suppergerrie2.sdrones.entities.EntityBasicDrone;
import com.suppergerrie2.sdrones.entities.EntityFighterDrone;
import com.suppergerrie2.sdrones.entities.EntityHaulerDrone;
import com.suppergerrie2.sdrones.entities.EntityTreeFarmDrone;
import com.suppergerrie2.sdrones.networking.DronesPacketHandler;
import com.suppergerrie2.sdrones.proxies.IProxy;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="sdrones", name="Suppergerrie2's Drone Mod", version="1.0", acceptedMinecraftVersions="[1.12]")
public class DroneMod {
    @Mod.Instance
    public static DroneMod instance;
    @SidedProxy(modId="sdrones", clientSide="com.suppergerrie2.sdrones.proxies.ClientProxy", serverSide="com.suppergerrie2.sdrones.proxies.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;
    static int entityID;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.registerDrone(EntityHaulerDrone.class, "hauler_drone");
        this.registerDrone(EntityFighterDrone.class, "fighter_drone");
        this.registerDrone(EntityTreeFarmDrone.class, "tree_farm_drone");
        proxy.preInit(event);
        logger.info("preInit");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DronesPacketHandler.register();
        logger.info("init");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("postInit");
    }

    private void registerDrone(Class<? extends EntityBasicDrone> droneClass, String name) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("sdrones", name), droneClass, (String)name, (int)entityID++, (Object)this, (int)80, (int)1, (boolean)true);
    }

    static {
        entityID = 0;
    }
}

