/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks.client;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.blay09.mods.horsetweaks.HorseUpgrade;
import net.blay09.mods.horsetweaks.HorseUpgradeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;

public class SaddleItemOverrides
extends ItemOverrideList {
    private Map<EnumSet<HorseUpgrade>, IBakedModel> modelCache = new HashMap<EnumSet<HorseUpgrade>, IBakedModel>();

    public SaddleItemOverrides(List<ItemOverride> overridesIn) {
        super(overridesIn);
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        EnumSet<HorseUpgrade> upgradeList = HorseUpgradeHelper.getUpgrades(stack);
        IBakedModel cachedModel = this.modelCache.get(upgradeList);
        if (cachedModel != null) {
            return cachedModel;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"layer0", (Object)"minecraft:items/saddle");
        int layer = 1;
        for (HorseUpgrade upgrade : upgradeList) {
            builder.put((Object)("layer" + layer), (Object)("horsetweaks:items/" + upgrade.name().toLowerCase(Locale.ENGLISH)));
            ++layer;
        }
        ItemLayerModel newModel = ItemLayerModel.INSTANCE.retexture(builder.build());
        Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        cachedModel = newModel.bake(newModel.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
        this.modelCache.put(upgradeList, cachedModel);
        return cachedModel;
    }
}

