/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks.client;

import java.util.EnumSet;
import net.blay09.mods.horsetweaks.HorseUpgrade;
import net.blay09.mods.horsetweaks.HorseUpgradeHelper;
import net.blay09.mods.horsetweaks.client.ModelSaddleUpgrades;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderAbstractHorse;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RenderEnhancedHorse
extends RenderAbstractHorse {
    private static final ModelSaddleUpgrades model = new ModelSaddleUpgrades();
    private static final ResourceLocation texture = new ResourceLocation("horsetweaks", "textures/entity/horse_upgrades.png");
    private final ItemStack FEATHER = new ItemStack(Items.field_151008_G);
    private final ItemStack CACTUS = new ItemStack((Block)Blocks.field_150434_aF);
    private final ItemStack LEAVES = new ItemStack((Block)Blocks.field_150362_t);
    private final ItemStack MAGMA_CREAM = new ItemStack(Items.field_151064_bs);

    public RenderEnhancedHorse(RenderManager renderManager) {
        super(renderManager);
    }

    public void renderUpgrades(AbstractHorse entity, double x, double y, double z, float partialTicks) {
        ItemStack saddle = entity.field_110296_bG.func_70301_a(0);
        EnumSet<HorseUpgrade> upgradeList = HorseUpgradeHelper.getUpgrades(saddle);
        if (upgradeList.isEmpty()) {
            return;
        }
        float interpolatedYaw = this.func_77034_a(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
        float handledRotationFloat = this.func_77044_a((EntityLivingBase)entity, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.func_77043_a((EntityLivingBase)entity, handledRotationFloat, interpolatedYaw, partialTicks);
        this.func_110776_a(texture);
        if (upgradeList.contains((Object)HorseUpgrade.EASY_JUMP)) {
            this.renderEasyJump();
        }
        if (upgradeList.contains((Object)HorseUpgrade.FROST_WALKER)) {
            this.renderFrostWalker();
        }
        if (upgradeList.contains((Object)HorseUpgrade.SWIMMING)) {
            this.renderSwimming();
        }
        if (upgradeList.contains((Object)HorseUpgrade.FEATHER_FALL)) {
            this.renderFeatherFall();
        }
        if (upgradeList.contains((Object)HorseUpgrade.LEAF_WALKER)) {
            this.renderLeafWalker();
        }
        if (upgradeList.contains((Object)HorseUpgrade.THORNS)) {
            this.renderThorns();
        }
        if (upgradeList.contains((Object)HorseUpgrade.FIRE_RESISTANCE)) {
            this.renderFireResistance();
        }
        GlStateManager.func_179121_F();
    }

    public void renderFeatherFall() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.33f, (float)1.45f, (float)0.4f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.FEATHER, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.33f, (float)1.45f, (float)0.4f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.FEATHER, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    public void renderEasyJump() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.3075f, (float)-0.001f);
        GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
        model.renderFootMetals();
        GlStateManager.func_179121_F();
    }

    public void renderSwimming() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.8f, (float)1.0f, (float)0.8f);
        model.renderSwimmingPlanks();
        GlStateManager.func_179121_F();
    }

    public void renderThorns() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.25f, (float)1.3f, (float)0.8f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.CACTUS, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.25f, (float)1.3f, (float)0.8f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.CACTUS, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    public void renderLeafWalker() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)-0.3f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.LEAVES, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.45f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.LEAVES, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    public void renderFrostWalker() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.51f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.101f, (float)1.0f, (float)1.025f);
        model.renderMainSaddle();
        GlStateManager.func_179121_F();
    }

    public void renderFireResistance() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.225f, (float)0.55f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.1f, (float)1.0f, (float)1.25f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.MAGMA_CREAM, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }
}

