/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks.client;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Function;
import net.blay09.mods.horsetweaks.CommonProxy;
import net.blay09.mods.horsetweaks.HorseUpgrade;
import net.blay09.mods.horsetweaks.client.EntityRenderHandler;
import net.blay09.mods.horsetweaks.client.SaddleItemOverrides;
import net.blay09.mods.horsetweaks.client.tweaks.EasyJumpHandler;
import net.blay09.mods.horsetweaks.client.tweaks.SwimmingHandler;
import net.blay09.mods.horsetweaks.tweaks.SaddleTooltipHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityRenderHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SaddleTooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EasyJumpHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SwimmingHandler());
    }

    @Override
    public void init() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("horsetweaks", "modded_saddle"), "inventory");
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Items.field_151141_av, 0, location);
    }

    @Override
    public void receivedHorseData(int entityId, ItemStack saddle) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            horse.field_110296_bG.func_70299_a(0, saddle);
        }
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        for (HorseUpgrade upgrade : HorseUpgrade.values) {
            event.getMap().func_174942_a(new ResourceLocation("horsetweaks", "items/" + upgrade.name().toLowerCase(Locale.ENGLISH)));
        }
    }

    @SubscribeEvent
    public void bakeModels(ModelBakeEvent event) {
        ItemLayerModel model = new ItemLayerModel(ImmutableList.of((Object)new ResourceLocation("minecraft", "items/saddle")), (ItemOverrideList)new SaddleItemOverrides(Collections.emptyList()));
        Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(new ResourceLocation("horsetweaks", "modded_saddle"), "inventory"), (Object)bakedModel);
    }
}

