/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFrostedIce;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockCrumblingMagma
extends BlockMagma {
    public static final PropertyInteger AGE = BlockFrostedIce.field_185682_a;

    public BlockCrumblingMagma() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)3)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((rand.nextInt(3) == 0 || this.countNeighbors(world, pos) < 4) && world.func_175671_l(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.func_185891_c()) {
            this.slightlyMelt(world, pos, state, rand, true);
        } else {
            world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        int count;
        if (block == this && (count = this.countNeighbors(world, pos)) < 2) {
            this.turnIntoLava(world, pos);
        }
    }

    private void turnIntoLava(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        world.func_190524_a(pos, (Block)Blocks.field_150353_l, pos);
    }

    private int countNeighbors(World world, BlockPos pos) {
        int count = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this || ++count < 4) continue;
            return count;
        }
        return count;
    }

    private void slightlyMelt(World world, BlockPos pos, IBlockState state, Random rand, boolean meltNeighbors) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 3) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        } else {
            this.turnIntoLava(world, pos);
            if (meltNeighbors) {
                for (EnumFacing facing : EnumFacing.values()) {
                    BlockPos neighbourPos = pos.func_177972_a(facing);
                    IBlockState blockState = world.func_180495_p(neighbourPos);
                    if (blockState.func_177230_c() != this) continue;
                    this.slightlyMelt(world, neighbourPos, blockState, rand, false);
                }
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }
}

