/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks;

import java.util.EnumSet;
import net.blay09.mods.horsetweaks.HorseTweaksConfig;
import net.blay09.mods.horsetweaks.HorseUpgrade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HorseUpgradeHelper {
    private static final String HORSE_TWEAKS_UPGRADES_TAG = "HorseTweaksUpgrades";
    private static final EnumSet<HorseUpgrade> EMPTY_UPGRADES = EnumSet.noneOf(HorseUpgrade.class);

    private static NBTTagCompound getHorseTweaksUpgrades(ItemStack saddle, boolean createIfNecessary) {
        NBTTagCompound compound = saddle.func_77978_p();
        if (compound == null) {
            if (createIfNecessary) {
                compound = new NBTTagCompound();
                saddle.func_77982_d(compound);
            } else {
                return new NBTTagCompound();
            }
        }
        NBTTagCompound upgrades = compound.func_74775_l(HORSE_TWEAKS_UPGRADES_TAG);
        if (createIfNecessary) {
            compound.func_74782_a(HORSE_TWEAKS_UPGRADES_TAG, (NBTBase)upgrades);
        }
        return upgrades;
    }

    public static boolean hasUpgrade(ItemStack saddle, HorseUpgrade upgrade) {
        NBTTagCompound upgrades = HorseUpgradeHelper.getHorseTweaksUpgrades(saddle, false);
        return upgrades.func_74767_n(upgrade.name());
    }

    public static ItemStack applyUpgrade(ItemStack saddle, HorseUpgrade upgrade) {
        NBTTagCompound upgrades = HorseUpgradeHelper.getHorseTweaksUpgrades(saddle, true);
        upgrades.func_74757_a(upgrade.name(), true);
        return saddle;
    }

    public static EnumSet<HorseUpgrade> getUpgrades(ItemStack saddle) {
        if (saddle.func_190926_b()) {
            return EMPTY_UPGRADES;
        }
        NBTTagCompound compound = HorseUpgradeHelper.getHorseTweaksUpgrades(saddle, false);
        EnumSet<HorseUpgrade> result = EnumSet.noneOf(HorseUpgrade.class);
        for (HorseUpgrade upgrade : HorseUpgrade.values) {
            if (!compound.func_74767_n(upgrade.name())) continue;
            result.add(upgrade);
        }
        return result;
    }

    public static boolean hasUpgrade(AbstractHorse horse, HorseUpgrade upgrade) {
        ItemStack saddle = horse.field_110296_bG.func_70301_a(0);
        return HorseUpgradeHelper.hasUpgrade(saddle, upgrade);
    }

    public static void damageSaddle(AbstractHorse horse) {
        if (HorseTweaksConfig.saddleDurability == 0) {
            return;
        }
        ItemStack saddle = horse.field_110296_bG.func_70301_a(0);
        Entity passenger = horse.func_184179_bs();
        saddle.func_77972_a(1, (EntityLivingBase)(passenger instanceof EntityPlayer ? (EntityPlayer)passenger : horse));
        if (saddle.func_77952_i() >= saddle.func_77958_k()) {
            horse.field_110296_bG.func_70296_d();
        }
    }
}

