/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.horsetweaks;

import net.blay09.mods.horsetweaks.CommonProxy;
import net.blay09.mods.horsetweaks.HorseTweaksConfig;
import net.blay09.mods.horsetweaks.HorseUpgrade;
import net.blay09.mods.horsetweaks.HorseUpgradeHelper;
import net.blay09.mods.horsetweaks.PlayerTickHandler;
import net.blay09.mods.horsetweaks.SyncHorseDataHandler;
import net.blay09.mods.horsetweaks.blocks.BlockCrumblingMagma;
import net.blay09.mods.horsetweaks.network.NetworkHandler;
import net.blay09.mods.horsetweaks.tweaks.CreativeInstantTamingHandler;
import net.blay09.mods.horsetweaks.tweaks.FeatherFallHandler;
import net.blay09.mods.horsetweaks.tweaks.FireWalkerHandler;
import net.blay09.mods.horsetweaks.tweaks.FrostWalkerHandler;
import net.blay09.mods.horsetweaks.tweaks.LeadNoDropHandler;
import net.blay09.mods.horsetweaks.tweaks.LeafWalkerHandler;
import net.blay09.mods.horsetweaks.tweaks.RejectPigSaddlesHandler;
import net.blay09.mods.horsetweaks.tweaks.SaddleRightClickHandler;
import net.blay09.mods.horsetweaks.tweaks.ThornsHandler;
import net.blay09.mods.horsetweaks.tweaks.UnmountSetHomeHandler;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="horsetweaks", name="Horse Tweaks", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class HorseTweaks {
    public static final String MOD_ID = "horsetweaks";
    private static Logger logger;
    @SidedProxy(serverSide="net.blay09.mods.horsetweaks.CommonProxy", clientSide="net.blay09.mods.horsetweaks.client.ClientProxy")
    public static CommonProxy proxy;
    public static CreativeTabs CREATIVE_TAB;
    @GameRegistry.ObjectHolder(value="crumbling_magma")
    public static Block blockCrumblingMagma;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)new CreativeInstantTamingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LeadNoDropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SaddleRightClickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new UnmountSetHomeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ThornsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FrostWalkerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FeatherFallHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SyncHorseDataHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LeafWalkerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RejectPigSaddlesHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FireWalkerHandler());
        proxy.preInit();
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        Items.field_151141_av.func_77656_e(HorseTweaksConfig.saddleDurability);
        Items.field_151141_av.setNoRepair();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new BlockCrumblingMagma().setRegistryName(MOD_ID, "crumbling_magma"));
    }

    static {
        CREATIVE_TAB = new CreativeTabs(MOD_ID){

            public ItemStack func_78016_d() {
                return new ItemStack(Items.field_151141_av);
            }

            public void func_78018_a(NonNullList<ItemStack> list) {
                ItemStack saddle = new ItemStack(Items.field_151141_av);
                list.add((Object)saddle);
                for (HorseUpgrade upgrade : HorseUpgrade.values) {
                    list.add((Object)HorseUpgradeHelper.applyUpgrade(saddle.func_77946_l(), upgrade));
                }
                ItemStack megaSaddle = saddle.func_77946_l();
                for (HorseUpgrade upgrade : HorseUpgrade.values) {
                    HorseUpgradeHelper.applyUpgrade(megaSaddle, upgrade);
                }
                list.add((Object)megaSaddle);
            }
        };
    }
}

