/*
 * Decompiled with CFR 0.152.
 */
package net.trentv.musicalenergy.common.item;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.trentv.musicalenergy.common.element.Element;

public abstract class ItemInstrument
extends Item {
    protected SoundEvent soundEffect;

    public ItemInstrument(SoundEvent soundEffect) {
        this.soundEffect = soundEffect;
        this.func_185043_a(new ResourceLocation("dooting"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!worldIn.field_72995_K) {
            Element[] a = ItemInstrument.getCurrentElements(stack);
            if (entityLiving.func_184612_cw() >= 10 * (a.length - 1)) {
                this.doot(a, entityLiving, worldIn, stack);
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public abstract void doot(Element[] var1, EntityLivingBase var2, World var3, ItemStack var4);

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int ticks;
        Element[] elements = ItemInstrument.getCurrentElements(stack);
        int time = player.func_184612_cw();
        int elementID = time / (ticks = 10);
        if (elementID < elements.length && (double)time / (double)ticks == (double)(time / ticks)) {
            float pitch = (float)elements[elementID].ID / (float)Element.MAX_ID * 2.0f;
            player.func_184185_a(this.soundEffect, 1.0f, pitch);
        }
    }

    public static final Element[] getCurrentElements(ItemStack heldItem) {
        Element[] e = new Element[]{};
        if (heldItem.func_77942_o()) {
            NBTTagList elementList = heldItem.func_77978_p().func_150295_c("elements", 8);
            ArrayList<Element> elements = new ArrayList<Element>();
            if (elementList.func_74745_c() > 0) {
                for (int i = 0; i < elementList.func_74745_c(); ++i) {
                    String tag = elementList.func_150307_f(i);
                    Element s = Element.deserialize(tag);
                    elements.add(s);
                }
                e = elements.toArray(new Element[elements.size()]);
            }
        }
        return e;
    }

    public static final void setCurrentElements(ItemStack heldItem, Element[] elements) {
        if (!heldItem.func_77942_o()) {
            heldItem.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound baseTag = heldItem.func_77978_p();
        NBTTagList elementList = new NBTTagList();
        for (Element e : elements) {
            elementList.func_74742_a((NBTBase)new NBTTagString(e.serialize()));
        }
        baseTag.func_74782_a("elements", (NBTBase)elementList);
    }
}

