/*
 * Decompiled with CFR 0.152.
 */
package net.trentv.musicalenergy.common.element;

import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.trentv.musicalenergy.MusicalEnergy;

public class Element {
    public static final HashMap<String, Element> elements = new HashMap();
    public final String NAME;
    public final int ID;
    public static int MAX_ID = -1;

    public Element(String name) {
        this.NAME = name;
        this.ID = MAX_ID++;
        if (elements.containsKey(name)) {
            MusicalEnergy.logger.warn("Element " + name + " already exists and must be unique.");
        } else {
            elements.put(name, this);
        }
    }

    public int onAOE(EntityLivingBase entity, World world, ItemStack stack) {
        return 0;
    }

    public int onBeam(EntityLivingBase entity, World world, ItemStack stack) {
        return 0;
    }

    public void onProjectile(EntityLivingBase entity, World world, ItemStack stack) {
    }

    public int onSelfCast(EntityLivingBase entity, World world, ItemStack stack) {
        return 0;
    }

    public String serialize() {
        return this.NAME;
    }

    public static Element deserialize(String str) {
        if (elements.containsKey(str)) {
            return elements.get(str);
        }
        return elements.get("null");
    }

    public static final List<Entity> getEntitiesNearby(int radius, EntityLivingBase entity, World world) {
        BlockPos pos1 = entity.func_180425_c().func_177981_b(radius).func_177964_d(radius).func_177965_g(radius);
        BlockPos pos2 = entity.func_180425_c().func_177979_c(radius).func_177970_e(radius).func_177985_f(radius);
        AxisAlignedBB boundingBox = new AxisAlignedBB(pos1, pos2);
        return world.func_175674_a((Entity)entity, boundingBox, null);
    }

    public static final EntityLivingBase raycastEntity(World world, Entity caster) {
        int rayDistance = 20;
        Vec3d startVec = caster.func_174824_e(1.0f);
        Vec3d lookVec = caster.func_70676_i(1.0f);
        Vec3d endVec = startVec.func_72441_c(lookVec.field_72450_a * (double)rayDistance, lookVec.field_72448_b * (double)rayDistance, lookVec.field_72449_c * (double)rayDistance);
        RayTraceResult result = world.func_72933_a(startVec, endVec);
        double blockHitDistance = 0.0;
        if (result != null) {
            blockHitDistance = result.field_72307_f.func_72438_d(startVec);
        }
        AxisAlignedBB entitySearchArea = new AxisAlignedBB(startVec.field_72450_a, startVec.field_72448_b, startVec.field_72449_c, endVec.field_72450_a, endVec.field_72448_b, endVec.field_72449_c);
        Entity hitEntity = null;
        double entityHitDistance = 0.0;
        for (Entity entity : world.func_175674_a(caster, entitySearchArea, EntitySelectors.field_180132_d)) {
            double distance;
            AxisAlignedBB collisionBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = collisionBB.func_72327_a(startVec, endVec);
            if (intercept == null || !((distance = startVec.func_72438_d(intercept.field_72307_f)) < blockHitDistance) && blockHitDistance != 0.0 || !(distance < entityHitDistance) && entityHitDistance != 0.0) continue;
            entityHitDistance = distance;
            hitEntity = entity;
        }
        if (hitEntity != null && hitEntity instanceof EntityLivingBase) {
            return (EntityLivingBase)hitEntity;
        }
        return null;
    }

    static {
        new Element("null");
    }
}

