/*
 * Decompiled with CFR 0.152.
 */
package net.trentv.musicalenergy.common;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.trentv.musicalenergy.common.MusicalObjects;

public abstract class CommonProxy {
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
    }

    public static class CommonEvents {
        @SubscribeEvent
        public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            for (SoundEvent obj : MusicalObjects.sounds) {
                event.getRegistry().register((IForgeRegistryEntry)obj);
            }
        }

        @SubscribeEvent
        public void registerItems(RegistryEvent.Register<Item> event) {
            for (Item obj : MusicalObjects.items) {
                event.getRegistry().register((IForgeRegistryEntry)obj);
            }
        }

        @SubscribeEvent
        public void registerRenderers(ModelRegistryEvent event) {
            for (Item obj : MusicalObjects.items) {
                ModelLoader.setCustomModelResourceLocation((Item)obj, (int)0, (ModelResourceLocation)new ModelResourceLocation(obj.getRegistryName(), "inventory"));
            }
        }
    }
}

